/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public class CriterionTriggerItemDurabilityChanged
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, ItemStack var1, int var22) {
        this.trigger(var0, var2 -> var2.matches(var1, var22));
    }

    public record a(Optional<ContextAwarePredicate> player, Optional<CriterionConditionItem> item, CriterionConditionValue.IntegerRange durability, CriterionConditionValue.IntegerRange delta) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.ADVANCEMENT_CODEC, "player").forGetter(a::player), (App)ExtraCodecs.strictOptionalField(CriterionConditionItem.CODEC, "item").forGetter(a::item), (App)ExtraCodecs.strictOptionalField(CriterionConditionValue.IntegerRange.CODEC, "durability", CriterionConditionValue.IntegerRange.ANY).forGetter(a::durability), (App)ExtraCodecs.strictOptionalField(CriterionConditionValue.IntegerRange.CODEC, "delta", CriterionConditionValue.IntegerRange.ANY).forGetter(a::delta)).apply((Applicative)var0, a::new));

        public static Criterion<a> changedDurability(Optional<CriterionConditionItem> var0, CriterionConditionValue.IntegerRange var1) {
            return a.changedDurability(Optional.empty(), var0, var1);
        }

        public static Criterion<a> changedDurability(Optional<ContextAwarePredicate> var0, Optional<CriterionConditionItem> var1, CriterionConditionValue.IntegerRange var2) {
            return CriterionTriggers.ITEM_DURABILITY_CHANGED.createCriterion(new a(var0, var1, var2, CriterionConditionValue.IntegerRange.ANY));
        }

        public boolean matches(ItemStack var0, int var1) {
            if (this.item.isPresent() && !this.item.get().matches(var0)) {
                return false;
            }
            if (!this.durability.matches(var0.getMaxDamage() - var1)) {
                return false;
            }
            return this.delta.matches(var0.getDamageValue() - var1);
        }
    }
}

