/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;

public record CriterionConditionMobEffect(Map<Holder<MobEffectList>, b> effectMap) {
    public static final Codec<CriterionConditionMobEffect> CODEC = Codec.unboundedMap(BuiltInRegistries.MOB_EFFECT.holderByNameCodec(), b.CODEC).xmap(CriterionConditionMobEffect::new, CriterionConditionMobEffect::effectMap);

    public boolean matches(Entity var0) {
        EntityLiving var1;
        return var0 instanceof EntityLiving && this.matches((var1 = (EntityLiving)var0).getActiveEffectsMap());
    }

    public boolean matches(EntityLiving var0) {
        return this.matches(var0.getActiveEffectsMap());
    }

    public boolean matches(Map<MobEffectList, MobEffect> var0) {
        for (Map.Entry<Holder<MobEffectList>, b> var2 : this.effectMap.entrySet()) {
            MobEffect var3 = var0.get(var2.getKey().value());
            if (var2.getValue().matches(var3)) continue;
            return false;
        }
        return true;
    }

    public record b(CriterionConditionValue.IntegerRange amplifier, CriterionConditionValue.IntegerRange duration, Optional<Boolean> ambient, Optional<Boolean> visible) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionValue.IntegerRange.CODEC, "amplifier", CriterionConditionValue.IntegerRange.ANY).forGetter(b::amplifier), (App)ExtraCodecs.strictOptionalField(CriterionConditionValue.IntegerRange.CODEC, "duration", CriterionConditionValue.IntegerRange.ANY).forGetter(b::duration), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "ambient").forGetter(b::ambient), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "visible").forGetter(b::visible)).apply((Applicative)var0, b::new));

        public b() {
            this(CriterionConditionValue.IntegerRange.ANY, CriterionConditionValue.IntegerRange.ANY, Optional.empty(), Optional.empty());
        }

        public boolean matches(@Nullable MobEffect var0) {
            if (var0 == null) {
                return false;
            }
            if (!this.amplifier.matches(var0.getAmplifier())) {
                return false;
            }
            if (!this.duration.matches(var0.getDuration())) {
                return false;
            }
            if (this.ambient.isPresent() && this.ambient.get().booleanValue() != var0.isAmbient()) {
                return false;
            }
            return !this.visible.isPresent() || this.visible.get().booleanValue() == var0.isVisible();
        }
    }

    public static class a {
        private final ImmutableMap.Builder<Holder<MobEffectList>, b> effectMap = ImmutableMap.builder();

        public static a effects() {
            return new a();
        }

        public a and(MobEffectList var0) {
            this.effectMap.put(var0.builtInRegistryHolder(), (Object)new b());
            return this;
        }

        public a and(MobEffectList var0, b var1) {
            this.effectMap.put(var0.builtInRegistryHolder(), (Object)var1);
            return this;
        }

        public Optional<CriterionConditionMobEffect> build() {
            return Optional.of(new CriterionConditionMobEffect((Map<Holder<MobEffectList>, b>)this.effectMap.build()));
        }
    }
}

