/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.advancements.critereon.CriterionConditionFluid;
import net.minecraft.advancements.critereon.CriterionConditionLight;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.levelgen.structure.Structure;

public record CriterionConditionLocation(Optional<b> position, Optional<ResourceKey<BiomeBase>> biome, Optional<ResourceKey<Structure>> structure, Optional<ResourceKey<World>> dimension, Optional<Boolean> smokey, Optional<CriterionConditionLight> light, Optional<CriterionConditionBlock> block, Optional<CriterionConditionFluid> fluid) {
    public static final Codec<CriterionConditionLocation> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(b.CODEC, "position").forGetter(CriterionConditionLocation::position), (App)ExtraCodecs.strictOptionalField(ResourceKey.codec(Registries.BIOME), "biome").forGetter(CriterionConditionLocation::biome), (App)ExtraCodecs.strictOptionalField(ResourceKey.codec(Registries.STRUCTURE), "structure").forGetter(CriterionConditionLocation::structure), (App)ExtraCodecs.strictOptionalField(ResourceKey.codec(Registries.DIMENSION), "dimension").forGetter(CriterionConditionLocation::dimension), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "smokey").forGetter(CriterionConditionLocation::smokey), (App)ExtraCodecs.strictOptionalField(CriterionConditionLight.CODEC, "light").forGetter(CriterionConditionLocation::light), (App)ExtraCodecs.strictOptionalField(CriterionConditionBlock.CODEC, "block").forGetter(CriterionConditionLocation::block), (App)ExtraCodecs.strictOptionalField(CriterionConditionFluid.CODEC, "fluid").forGetter(CriterionConditionLocation::fluid)).apply((Applicative)var0, CriterionConditionLocation::new));

    private static Optional<CriterionConditionLocation> of(Optional<b> var0, Optional<ResourceKey<BiomeBase>> var1, Optional<ResourceKey<Structure>> var2, Optional<ResourceKey<World>> var3, Optional<Boolean> var4, Optional<CriterionConditionLight> var5, Optional<CriterionConditionBlock> var6, Optional<CriterionConditionFluid> var7) {
        if (var0.isEmpty() && var1.isEmpty() && var2.isEmpty() && var3.isEmpty() && var4.isEmpty() && var5.isEmpty() && var6.isEmpty() && var7.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new CriterionConditionLocation(var0, var1, var2, var3, var4, var5, var6, var7));
    }

    public boolean matches(WorldServer var0, double var1, double var3, double var5) {
        if (this.position.isPresent() && !this.position.get().matches(var1, var3, var5)) {
            return false;
        }
        if (this.dimension.isPresent() && this.dimension.get() != var0.dimension()) {
            return false;
        }
        BlockPosition var7 = BlockPosition.containing(var1, var3, var5);
        boolean var8 = var0.isLoaded(var7);
        if (!(!this.biome.isPresent() || var8 && var0.getBiome(var7).is(this.biome.get()))) {
            return false;
        }
        if (!(!this.structure.isPresent() || var8 && var0.structureManager().getStructureWithPieceAt(var7, this.structure.get()).isValid())) {
            return false;
        }
        if (this.smokey.isPresent() && (!var8 || this.smokey.get() != BlockCampfire.isSmokeyPos(var0, var7))) {
            return false;
        }
        if (this.light.isPresent() && !this.light.get().matches(var0, var7)) {
            return false;
        }
        if (this.block.isPresent() && !this.block.get().matches(var0, var7)) {
            return false;
        }
        return !this.fluid.isPresent() || this.fluid.get().matches(var0, var7);
    }

    record b(CriterionConditionValue.DoubleRange x, CriterionConditionValue.DoubleRange y, CriterionConditionValue.DoubleRange z) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionValue.DoubleRange.CODEC, "x", CriterionConditionValue.DoubleRange.ANY).forGetter(b::x), (App)ExtraCodecs.strictOptionalField(CriterionConditionValue.DoubleRange.CODEC, "y", CriterionConditionValue.DoubleRange.ANY).forGetter(b::y), (App)ExtraCodecs.strictOptionalField(CriterionConditionValue.DoubleRange.CODEC, "z", CriterionConditionValue.DoubleRange.ANY).forGetter(b::z)).apply((Applicative)var0, b::new));

        static Optional<b> of(CriterionConditionValue.DoubleRange var0, CriterionConditionValue.DoubleRange var1, CriterionConditionValue.DoubleRange var2) {
            if (var0.isAny() && var1.isAny() && var2.isAny()) {
                return Optional.empty();
            }
            return Optional.of(new b(var0, var1, var2));
        }

        public boolean matches(double var0, double var2, double var4) {
            return this.x.matches(var0) && this.y.matches(var2) && this.z.matches(var4);
        }
    }

    public static class a {
        private CriterionConditionValue.DoubleRange x = CriterionConditionValue.DoubleRange.ANY;
        private CriterionConditionValue.DoubleRange y = CriterionConditionValue.DoubleRange.ANY;
        private CriterionConditionValue.DoubleRange z = CriterionConditionValue.DoubleRange.ANY;
        private Optional<ResourceKey<BiomeBase>> biome = Optional.empty();
        private Optional<ResourceKey<Structure>> structure = Optional.empty();
        private Optional<ResourceKey<World>> dimension = Optional.empty();
        private Optional<Boolean> smokey = Optional.empty();
        private Optional<CriterionConditionLight> light = Optional.empty();
        private Optional<CriterionConditionBlock> block = Optional.empty();
        private Optional<CriterionConditionFluid> fluid = Optional.empty();

        public static a location() {
            return new a();
        }

        public static a inBiome(ResourceKey<BiomeBase> var0) {
            return a.location().setBiome(var0);
        }

        public static a inDimension(ResourceKey<World> var0) {
            return a.location().setDimension(var0);
        }

        public static a inStructure(ResourceKey<Structure> var0) {
            return a.location().setStructure(var0);
        }

        public static a atYLocation(CriterionConditionValue.DoubleRange var0) {
            return a.location().setY(var0);
        }

        public a setX(CriterionConditionValue.DoubleRange var0) {
            this.x = var0;
            return this;
        }

        public a setY(CriterionConditionValue.DoubleRange var0) {
            this.y = var0;
            return this;
        }

        public a setZ(CriterionConditionValue.DoubleRange var0) {
            this.z = var0;
            return this;
        }

        public a setBiome(ResourceKey<BiomeBase> var0) {
            this.biome = Optional.of(var0);
            return this;
        }

        public a setStructure(ResourceKey<Structure> var0) {
            this.structure = Optional.of(var0);
            return this;
        }

        public a setDimension(ResourceKey<World> var0) {
            this.dimension = Optional.of(var0);
            return this;
        }

        public a setLight(CriterionConditionLight.a var0) {
            this.light = Optional.of(var0.build());
            return this;
        }

        public a setBlock(CriterionConditionBlock.a var0) {
            this.block = Optional.of(var0.build());
            return this;
        }

        public a setFluid(CriterionConditionFluid.a var0) {
            this.fluid = Optional.of(var0.build());
            return this;
        }

        public a setSmokey(boolean var0) {
            this.smokey = Optional.of(var0);
            return this;
        }

        public CriterionConditionLocation build() {
            Optional<b> var0 = b.of(this.x, this.y, this.z);
            return new CriterionConditionLocation(var0, this.biome, this.structure, this.dimension, this.smokey, this.light, this.block, this.fluid);
        }
    }
}

