/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.CriterionConditionEnchantments;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;

public record CriterionConditionItem(Optional<TagKey<Item>> tag, Optional<HolderSet<Item>> items, CriterionConditionValue.IntegerRange count, CriterionConditionValue.IntegerRange durability, List<CriterionConditionEnchantments> enchantments, List<CriterionConditionEnchantments> storedEnchantments, Optional<Holder<PotionRegistry>> potion, Optional<CriterionConditionNBT> nbt) {
    private static final Codec<HolderSet<Item>> ITEMS_CODEC = BuiltInRegistries.ITEM.holderByNameCodec().listOf().xmap(HolderSet::direct, var0 -> var0.stream().toList());
    public static final Codec<CriterionConditionItem> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(TagKey.codec(Registries.ITEM), "tag").forGetter(CriterionConditionItem::tag), (App)ExtraCodecs.strictOptionalField(ITEMS_CODEC, "items").forGetter(CriterionConditionItem::items), (App)ExtraCodecs.strictOptionalField(CriterionConditionValue.IntegerRange.CODEC, "count", CriterionConditionValue.IntegerRange.ANY).forGetter(CriterionConditionItem::count), (App)ExtraCodecs.strictOptionalField(CriterionConditionValue.IntegerRange.CODEC, "durability", CriterionConditionValue.IntegerRange.ANY).forGetter(CriterionConditionItem::durability), (App)ExtraCodecs.strictOptionalField(CriterionConditionEnchantments.CODEC.listOf(), "enchantments", List.of()).forGetter(CriterionConditionItem::enchantments), (App)ExtraCodecs.strictOptionalField(CriterionConditionEnchantments.CODEC.listOf(), "stored_enchantments", List.of()).forGetter(CriterionConditionItem::storedEnchantments), (App)ExtraCodecs.strictOptionalField(BuiltInRegistries.POTION.holderByNameCodec(), "potion").forGetter(CriterionConditionItem::potion), (App)ExtraCodecs.strictOptionalField(CriterionConditionNBT.CODEC, "nbt").forGetter(CriterionConditionItem::nbt)).apply((Applicative)var0, CriterionConditionItem::new));

    public boolean matches(ItemStack var0) {
        Map<Enchantment, Integer> var1;
        if (this.tag.isPresent() && !var0.is(this.tag.get())) {
            return false;
        }
        if (this.items.isPresent() && !var0.is(this.items.get())) {
            return false;
        }
        if (!this.count.matches(var0.getCount())) {
            return false;
        }
        if (!this.durability.isAny() && !var0.isDamageableItem()) {
            return false;
        }
        if (!this.durability.matches(var0.getMaxDamage() - var0.getDamageValue())) {
            return false;
        }
        if (this.nbt.isPresent() && !this.nbt.get().matches(var0)) {
            return false;
        }
        if (!this.enchantments.isEmpty()) {
            var1 = EnchantmentManager.deserializeEnchantments(var0.getEnchantmentTags());
            for (CriterionConditionEnchantments var3 : this.enchantments) {
                if (var3.containedIn(var1)) continue;
                return false;
            }
        }
        if (!this.storedEnchantments.isEmpty()) {
            var1 = EnchantmentManager.deserializeEnchantments(ItemEnchantedBook.getEnchantments(var0));
            for (CriterionConditionEnchantments var3 : this.storedEnchantments) {
                if (var3.containedIn(var1)) continue;
                return false;
            }
        }
        return !this.potion.isPresent() || this.potion.get().value() == PotionUtil.getPotion(var0);
    }

    public static class a {
        private final ImmutableList.Builder<CriterionConditionEnchantments> enchantments = ImmutableList.builder();
        private final ImmutableList.Builder<CriterionConditionEnchantments> storedEnchantments = ImmutableList.builder();
        private Optional<HolderSet<Item>> items = Optional.empty();
        private Optional<TagKey<Item>> tag = Optional.empty();
        private CriterionConditionValue.IntegerRange count = CriterionConditionValue.IntegerRange.ANY;
        private CriterionConditionValue.IntegerRange durability = CriterionConditionValue.IntegerRange.ANY;
        private Optional<Holder<PotionRegistry>> potion = Optional.empty();
        private Optional<CriterionConditionNBT> nbt = Optional.empty();

        private a() {
        }

        public static a item() {
            return new a();
        }

        public a of(IMaterial ... var02) {
            this.items = Optional.of(HolderSet.direct(var0 -> var0.asItem().builtInRegistryHolder(), var02));
            return this;
        }

        public a of(TagKey<Item> var0) {
            this.tag = Optional.of(var0);
            return this;
        }

        public a withCount(CriterionConditionValue.IntegerRange var0) {
            this.count = var0;
            return this;
        }

        public a hasDurability(CriterionConditionValue.IntegerRange var0) {
            this.durability = var0;
            return this;
        }

        public a isPotion(PotionRegistry var0) {
            this.potion = Optional.of(var0.builtInRegistryHolder());
            return this;
        }

        public a hasNbt(NBTTagCompound var0) {
            this.nbt = Optional.of(new CriterionConditionNBT(var0));
            return this;
        }

        public a hasEnchantment(CriterionConditionEnchantments var0) {
            this.enchantments.add((Object)var0);
            return this;
        }

        public a hasStoredEnchantment(CriterionConditionEnchantments var0) {
            this.storedEnchantments.add((Object)var0);
            return this;
        }

        public CriterionConditionItem build() {
            ImmutableList var0 = this.enchantments.build();
            ImmutableList var1 = this.storedEnchantments.build();
            return new CriterionConditionItem(this.tag, this.items, this.count, this.durability, (List<CriterionConditionEnchantments>)var0, (List<CriterionConditionEnchantments>)var1, this.potion, this.nbt);
        }
    }
}

