/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import java.io.Serializable;
import java.time.Instant;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;

public class CriterionProgress {
    @Nullable
    private Instant obtained;

    public CriterionProgress() {
    }

    public CriterionProgress(Instant var0) {
        this.obtained = var0;
    }

    public boolean isDone() {
        return this.obtained != null;
    }

    public void grant() {
        this.obtained = Instant.now();
    }

    public void revoke() {
        this.obtained = null;
    }

    @Nullable
    public Instant getObtained() {
        return this.obtained;
    }

    public String toString() {
        return "CriterionProgress{obtained=" + (Serializable)(this.obtained == null ? "false" : this.obtained) + "}";
    }

    public void serializeToNetwork(PacketDataSerializer var0) {
        var0.writeNullable(this.obtained, PacketDataSerializer::writeInstant);
    }

    public static CriterionProgress fromNetwork(PacketDataSerializer var0) {
        CriterionProgress var1 = new CriterionProgress();
        var1.obtained = (Instant)var0.readNullable(PacketDataSerializer::readInstant);
        return var1;
    }
}

