/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CacheableFunction;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public record AdvancementRewards(int experience, List<MinecraftKey> loot, List<MinecraftKey> recipes, Optional<CacheableFunction> function) {
    public static final Codec<AdvancementRewards> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(Codec.INT, "experience", 0).forGetter(AdvancementRewards::experience), (App)ExtraCodecs.strictOptionalField(MinecraftKey.CODEC.listOf(), "loot", List.of()).forGetter(AdvancementRewards::loot), (App)ExtraCodecs.strictOptionalField(MinecraftKey.CODEC.listOf(), "recipes", List.of()).forGetter(AdvancementRewards::recipes), (App)ExtraCodecs.strictOptionalField(CacheableFunction.CODEC, "function").forGetter(AdvancementRewards::function)).apply((Applicative)var0, AdvancementRewards::new));
    public static final AdvancementRewards EMPTY = new AdvancementRewards(0, List.of(), List.of(), Optional.empty());

    public void grant(EntityPlayer var0) {
        var0.giveExperiencePoints(this.experience);
        LootParams var12 = new LootParams.a(var0.serverLevel()).withParameter(LootContextParameters.THIS_ENTITY, var0).withParameter(LootContextParameters.ORIGIN, var0.position()).create(LootContextParameterSets.ADVANCEMENT_REWARD);
        boolean var22 = false;
        for (MinecraftKey var4 : this.loot) {
            for (ItemStack var6 : var0.server.getLootData().getLootTable(var4).getRandomItems(var12)) {
                if (var0.addItem(var6)) {
                    var0.level().playSound(null, var0.getX(), var0.getY(), var0.getZ(), SoundEffects.ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((var0.getRandom().nextFloat() - var0.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    var22 = true;
                    continue;
                }
                EntityItem var7 = var0.drop(var6, false);
                if (var7 == null) continue;
                var7.setNoPickUpDelay();
                var7.setTarget(var0.getUUID());
            }
        }
        if (var22) {
            var0.containerMenu.broadcastChanges();
        }
        if (!this.recipes.isEmpty()) {
            var0.awardRecipesByKey(this.recipes);
        }
        MinecraftServer var3 = var0.server;
        this.function.flatMap(var1 -> var1.get(var3.getFunctions())).ifPresent(var2 -> var3.getFunctions().execute((CommandFunction<CommandListenerWrapper>)var2, var0.createCommandSourceStack().withSuppressedOutput().withPermission(2)));
    }

    public static class a {
        private int experience;
        private final ImmutableList.Builder<MinecraftKey> loot = ImmutableList.builder();
        private final ImmutableList.Builder<MinecraftKey> recipes = ImmutableList.builder();
        private Optional<MinecraftKey> function = Optional.empty();

        public static a experience(int var0) {
            return new a().addExperience(var0);
        }

        public a addExperience(int var0) {
            this.experience += var0;
            return this;
        }

        public static a loot(MinecraftKey var0) {
            return new a().addLootTable(var0);
        }

        public a addLootTable(MinecraftKey var0) {
            this.loot.add((Object)var0);
            return this;
        }

        public static a recipe(MinecraftKey var0) {
            return new a().addRecipe(var0);
        }

        public a addRecipe(MinecraftKey var0) {
            this.recipes.add((Object)var0);
            return this;
        }

        public static a function(MinecraftKey var0) {
            return new a().runs(var0);
        }

        public a runs(MinecraftKey var0) {
            this.function = Optional.of(var0);
            return this;
        }

        public AdvancementRewards build() {
            return new AdvancementRewards(this.experience, (List<MinecraftKey>)this.loot.build(), (List<MinecraftKey>)this.recipes.build(), this.function.map(CacheableFunction::new));
        }
    }
}

