/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public class AdvancementDisplay {
    public static final Codec<AdvancementDisplay> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ItemStack.ADVANCEMENT_ICON_CODEC.fieldOf("icon").forGetter(AdvancementDisplay::getIcon), (App)ComponentSerialization.CODEC.fieldOf("title").forGetter(AdvancementDisplay::getTitle), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(AdvancementDisplay::getDescription), (App)ExtraCodecs.strictOptionalField(MinecraftKey.CODEC, "background").forGetter(AdvancementDisplay::getBackground), (App)ExtraCodecs.strictOptionalField(AdvancementFrameType.CODEC, "frame", AdvancementFrameType.TASK).forGetter(AdvancementDisplay::getType), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "show_toast", true).forGetter(AdvancementDisplay::shouldShowToast), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "announce_to_chat", true).forGetter(AdvancementDisplay::shouldAnnounceChat), (App)ExtraCodecs.strictOptionalField(Codec.BOOL, "hidden", false).forGetter(AdvancementDisplay::isHidden)).apply((Applicative)var0, AdvancementDisplay::new));
    private final IChatBaseComponent title;
    private final IChatBaseComponent description;
    private final ItemStack icon;
    private final Optional<MinecraftKey> background;
    private final AdvancementFrameType type;
    private final boolean showToast;
    private final boolean announceChat;
    private final boolean hidden;
    private float x;
    private float y;

    public AdvancementDisplay(ItemStack var0, IChatBaseComponent var1, IChatBaseComponent var2, Optional<MinecraftKey> var3, AdvancementFrameType var4, boolean var5, boolean var6, boolean var7) {
        this.title = var1;
        this.description = var2;
        this.icon = var0;
        this.background = var3;
        this.type = var4;
        this.showToast = var5;
        this.announceChat = var6;
        this.hidden = var7;
    }

    public void setLocation(float var0, float var1) {
        this.x = var0;
        this.y = var1;
    }

    public IChatBaseComponent getTitle() {
        return this.title;
    }

    public IChatBaseComponent getDescription() {
        return this.description;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public Optional<MinecraftKey> getBackground() {
        return this.background;
    }

    public AdvancementFrameType getType() {
        return this.type;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean shouldShowToast() {
        return this.showToast;
    }

    public boolean shouldAnnounceChat() {
        return this.announceChat;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void serializeToNetwork(PacketDataSerializer var0) {
        var0.writeComponent(this.title);
        var0.writeComponent(this.description);
        var0.writeItem(this.icon);
        var0.writeEnum(this.type);
        int var1 = 0;
        if (this.background.isPresent()) {
            var1 |= 1;
        }
        if (this.showToast) {
            var1 |= 2;
        }
        if (this.hidden) {
            var1 |= 4;
        }
        var0.writeInt(var1);
        this.background.ifPresent(var0::writeResourceLocation);
        var0.writeFloat(this.x);
        var0.writeFloat(this.y);
    }

    public static AdvancementDisplay fromNetwork(PacketDataSerializer var0) {
        IChatBaseComponent var1 = var0.readComponentTrusted();
        IChatBaseComponent var2 = var0.readComponentTrusted();
        ItemStack var3 = var0.readItem();
        AdvancementFrameType var4 = var0.readEnum(AdvancementFrameType.class);
        int var5 = var0.readInt();
        Optional<MinecraftKey> var6 = (var5 & 1) != 0 ? Optional.of(var0.readResourceLocation()) : Optional.empty();
        boolean var7 = (var5 & 2) != 0;
        boolean var8 = (var5 & 4) != 0;
        AdvancementDisplay var9 = new AdvancementDisplay(var3, var1, var2, var6, var4, var7, false, var8);
        var9.setLocation(var0.readFloat(), var0.readFloat());
        return var9;
    }
}

