/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCubePoint;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeDiscreteSlice;

public class VoxelShapeSlice
extends VoxelShape {
    private final VoxelShape delegate;
    private final EnumDirection.EnumAxis axis;
    private static final DoubleList SLICE_COORDS = new VoxelShapeCubePoint(1);

    public VoxelShapeSlice(VoxelShape var0, EnumDirection.EnumAxis var1, int var2) {
        super(VoxelShapeSlice.makeSlice(var0.shape, var1, var2));
        this.delegate = var0;
        this.axis = var1;
    }

    private static VoxelShapeDiscrete makeSlice(VoxelShapeDiscrete var0, EnumDirection.EnumAxis var1, int var2) {
        return new VoxelShapeDiscreteSlice(var0, var1.choose(var2, 0, 0), var1.choose(0, var2, 0), var1.choose(0, 0, var2), var1.choose(var2 + 1, var0.xSize, var0.xSize), var1.choose(var0.ySize, var2 + 1, var0.ySize), var1.choose(var0.zSize, var0.zSize, var2 + 1));
    }

    @Override
    protected DoubleList getCoords(EnumDirection.EnumAxis var0) {
        if (var0 == this.axis) {
            return SLICE_COORDS;
        }
        return this.delegate.getCoords(var0);
    }
}

