/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public record LootItemConditionReference(MinecraftKey name) implements LootItemCondition
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<LootItemConditionReference> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MinecraftKey.CODEC.fieldOf("name").forGetter(LootItemConditionReference::name)).apply((Applicative)var0, LootItemConditionReference::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.REFERENCE;
    }

    @Override
    public void validate(LootCollector var0) {
        LootDataId<LootItemCondition> var1 = new LootDataId<LootItemCondition>(LootDataType.PREDICATE, this.name);
        if (var0.hasVisitedElement(var1)) {
            var0.reportProblem("Condition " + this.name + " is recursively called");
            return;
        }
        LootItemCondition.super.validate(var0);
        var0.resolver().getElementOptional(var1).ifPresentOrElse(var2 -> var2.validate(var0.enterElement(".{" + this.name + "}", var1)), () -> var0.reportProblem("Unknown condition table called " + this.name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(LootTableInfo var0) {
        LootItemCondition var1 = var0.getResolver().getElement(LootDataType.PREDICATE, this.name);
        if (var1 == null) {
            LOGGER.warn("Tried using unknown condition table called {}", (Object)this.name);
            return false;
        }
        LootTableInfo.c<LootItemCondition> var2 = LootTableInfo.createVisitedEntry(var1);
        if (var0.pushVisitedElement(var2)) {
            try {
                boolean bl = var1.test(var0);
                return bl;
            }
            finally {
                var0.popVisitedElement(var2);
            }
        }
        LOGGER.warn("Detected infinite loop in loot tables");
        return false;
    }

    public static LootItemCondition.a conditionReference(MinecraftKey var0) {
        return () -> new LootItemConditionReference(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }
}

