/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.phys.Vec3D;

public record LootItemConditionEntityProperty(Optional<CriterionConditionEntity> predicate, LootTableInfo.EntityTarget entityTarget) implements LootItemCondition
{
    public static final Codec<LootItemConditionEntityProperty> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.CODEC, "predicate").forGetter(LootItemConditionEntityProperty::predicate), (App)LootTableInfo.EntityTarget.CODEC.fieldOf("entity").forGetter(LootItemConditionEntityProperty::entityTarget)).apply((Applicative)var0, LootItemConditionEntityProperty::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.ENTITY_PROPERTIES;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.ORIGIN, this.entityTarget.getParam());
    }

    @Override
    public boolean test(LootTableInfo var0) {
        Entity var1 = var0.getParamOrNull(this.entityTarget.getParam());
        Vec3D var2 = var0.getParamOrNull(LootContextParameters.ORIGIN);
        return this.predicate.isEmpty() || this.predicate.get().matches(var0.getLevel(), var2, var1);
    }

    public static LootItemCondition.a entityPresent(LootTableInfo.EntityTarget var0) {
        return LootItemConditionEntityProperty.hasProperties(var0, CriterionConditionEntity.a.entity());
    }

    public static LootItemCondition.a hasProperties(LootTableInfo.EntityTarget var0, CriterionConditionEntity.a var1) {
        return () -> new LootItemConditionEntityProperty(Optional.of(var1.build()), var0);
    }

    public static LootItemCondition.a hasProperties(LootTableInfo.EntityTarget var0, CriterionConditionEntity var1) {
        return () -> new LootItemConditionEntityProperty(Optional.of(var1), var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }
}

