/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.CriterionConditionDamageSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.phys.Vec3D;

public record LootItemConditionDamageSourceProperties(Optional<CriterionConditionDamageSource> predicate) implements LootItemCondition
{
    public static final Codec<LootItemConditionDamageSourceProperties> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionDamageSource.CODEC, "predicate").forGetter(LootItemConditionDamageSourceProperties::predicate)).apply((Applicative)var0, LootItemConditionDamageSourceProperties::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.DAMAGE_SOURCE_PROPERTIES;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.ORIGIN, LootContextParameters.DAMAGE_SOURCE);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        DamageSource var1 = var0.getParamOrNull(LootContextParameters.DAMAGE_SOURCE);
        Vec3D var2 = var0.getParamOrNull(LootContextParameters.ORIGIN);
        if (var2 == null || var1 == null) {
            return false;
        }
        return this.predicate.isEmpty() || this.predicate.get().matches(var0.getLevel(), var2, var1);
    }

    public static LootItemCondition.a hasDamageSource(CriterionConditionDamageSource.a var0) {
        return () -> new LootItemConditionDamageSourceProperties(Optional.of(var0.build()));
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }
}

