/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.INamable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class LootItemFunctionCopyNBT
extends LootItemFunctionConditional {
    public static final Codec<LootItemFunctionCopyNBT> CODEC = RecordCodecBuilder.create(var02 -> LootItemFunctionCopyNBT.commonFields(var02).and(var02.group((App)NbtProviders.CODEC.fieldOf("source").forGetter(var0 -> var0.source), (App)b.CODEC.listOf().fieldOf("ops").forGetter(var0 -> var0.operations))).apply((Applicative)var02, LootItemFunctionCopyNBT::new));
    private final NbtProvider source;
    private final List<b> operations;

    LootItemFunctionCopyNBT(List<LootItemCondition> var0, NbtProvider var1, List<b> var2) {
        super(var0);
        this.source = var1;
        this.operations = List.copyOf(var2);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.COPY_NBT;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.source.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        NBTBase var22 = this.source.get(var1);
        if (var22 != null) {
            this.operations.forEach(var2 -> var2.apply(var0::getOrCreateTag, var22));
        }
        return var0;
    }

    public static a copyData(NbtProvider var0) {
        return new a(var0);
    }

    public static a copyData(LootTableInfo.EntityTarget var0) {
        return new a(ContextNbtProvider.forContextEntity(var0));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final NbtProvider source;
        private final List<b> ops = Lists.newArrayList();

        a(NbtProvider var0) {
            this.source = var0;
        }

        public a copy(String var0, String var1, Action var2) {
            try {
                this.ops.add(new b(d.of(var0), d.of(var1), var2));
            }
            catch (CommandSyntaxException var3) {
                throw new IllegalArgumentException(var3);
            }
            return this;
        }

        public a copy(String var0, String var1) {
            return this.copy(var0, var1, Action.REPLACE);
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionCopyNBT(this.getConditions(), this.source, this.ops);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    record b(d sourcePath, d targetPath, Action op) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)d.CODEC.fieldOf("source").forGetter(b::sourcePath), (App)d.CODEC.fieldOf("target").forGetter(b::targetPath), (App)Action.CODEC.fieldOf("op").forGetter(b::op)).apply((Applicative)var0, b::new));

        public void apply(Supplier<NBTBase> var0, NBTBase var1) {
            try {
                List<NBTBase> var2 = this.sourcePath.path().get(var1);
                if (!var2.isEmpty()) {
                    this.op.merge(var0.get(), this.targetPath.path(), var2);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Action
    extends Enum<Action>
    implements INamable {
        public static final /* enum */ Action REPLACE = new Action("replace"){

            @Override
            public void merge(NBTBase var0, ArgumentNBTKey.g var1, List<NBTBase> var2) throws CommandSyntaxException {
                var1.set(var0, (NBTBase)Iterables.getLast(var2));
            }
        };
        public static final /* enum */ Action APPEND = new Action("append"){

            @Override
            public void merge(NBTBase var0, ArgumentNBTKey.g var1, List<NBTBase> var2) throws CommandSyntaxException {
                List<NBTBase> var3 = var1.getOrCreate(var0, NBTTagList::new);
                var3.forEach(var12 -> {
                    if (var12 instanceof NBTTagList) {
                        var2.forEach(var1 -> ((NBTTagList)var12).add(var1.copy()));
                    }
                });
            }
        };
        public static final /* enum */ Action MERGE = new Action("merge"){

            @Override
            public void merge(NBTBase var0, ArgumentNBTKey.g var1, List<NBTBase> var2) throws CommandSyntaxException {
                List<NBTBase> var3 = var1.getOrCreate(var0, NBTTagCompound::new);
                var3.forEach(var12 -> {
                    if (var12 instanceof NBTTagCompound) {
                        var2.forEach(var1 -> {
                            if (var1 instanceof NBTTagCompound) {
                                ((NBTTagCompound)var12).merge((NBTTagCompound)var1);
                            }
                        });
                    }
                });
            }
        };
        public static final Codec<Action> CODEC;
        private final String name;
        private static final /* synthetic */ Action[] f;

        public static Action[] values() {
            return (Action[])f.clone();
        }

        public static Action valueOf(String var0) {
            return Enum.valueOf(Action.class, var0);
        }

        public abstract void merge(NBTBase var1, ArgumentNBTKey.g var2, List<NBTBase> var3) throws CommandSyntaxException;

        Action(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Action[] a() {
            return new Action[]{REPLACE, APPEND, MERGE};
        }

        static {
            f = Action.a();
            CODEC = INamable.fromEnum(Action::values);
        }
    }

    record d(String string, ArgumentNBTKey.g path) {
        public static final Codec<d> CODEC = Codec.STRING.comapFlatMap(var0 -> {
            try {
                return DataResult.success((Object)d.of(var0));
            }
            catch (CommandSyntaxException var1) {
                return DataResult.error(() -> "Failed to parse path " + var0 + ": " + var1.getMessage());
            }
        }, d::string);

        public static d of(String var0) throws CommandSyntaxException {
            ArgumentNBTKey.g var1 = new ArgumentNBTKey().parse(new StringReader(var0));
            return new d(var0, var1);
        }
    }
}

