/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootEnchantLevel
extends LootItemFunctionConditional {
    public static final Codec<LootEnchantLevel> CODEC = RecordCodecBuilder.create(var02 -> LootEnchantLevel.commonFields(var02).and(var02.group((App)NumberProviders.CODEC.fieldOf("levels").forGetter(var0 -> var0.levels), (App)Codec.BOOL.fieldOf("treasure").orElse((Object)false).forGetter(var0 -> var0.treasure))).apply((Applicative)var02, LootEnchantLevel::new));
    private final NumberProvider levels;
    private final boolean treasure;

    LootEnchantLevel(List<LootItemCondition> var0, NumberProvider var1, boolean var2) {
        super(var0);
        this.levels = var1;
        this.treasure = var2;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.ENCHANT_WITH_LEVELS;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.levels.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        RandomSource var2 = var1.getRandom();
        return EnchantmentManager.enchantItem(var2, var0, this.levels.getInt(var1), this.treasure);
    }

    public static a enchantWithLevels(NumberProvider var0) {
        return new a(var0);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final NumberProvider levels;
        private boolean treasure;

        public a(NumberProvider var0) {
            this.levels = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        public a allowTreasure() {
            this.treasure = true;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootEnchantLevel(this.getConditions(), this.levels, this.treasure);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

