/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootItemUser;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;

public class LootCollector {
    private final ProblemReporter reporter;
    private final LootContextParameterSet params;
    private final LootDataResolver resolver;
    private final Set<LootDataId<?>> visitedElements;

    public LootCollector(ProblemReporter var0, LootContextParameterSet var1, LootDataResolver var2) {
        this(var0, var1, var2, Set.of());
    }

    private LootCollector(ProblemReporter var0, LootContextParameterSet var1, LootDataResolver var2, Set<LootDataId<?>> var3) {
        this.reporter = var0;
        this.params = var1;
        this.resolver = var2;
        this.visitedElements = var3;
    }

    public LootCollector forChild(String var0) {
        return new LootCollector(this.reporter.forChild(var0), this.params, this.resolver, this.visitedElements);
    }

    public LootCollector enterElement(String var0, LootDataId<?> var1) {
        ImmutableSet var2 = ImmutableSet.builder().addAll(this.visitedElements).add(var1).build();
        return new LootCollector(this.reporter.forChild(var0), this.params, this.resolver, (Set<LootDataId<?>>)var2);
    }

    public boolean hasVisitedElement(LootDataId<?> var0) {
        return this.visitedElements.contains(var0);
    }

    public void reportProblem(String var0) {
        this.reporter.report(var0);
    }

    public void validateUser(LootItemUser var0) {
        this.params.validateUser(this, var0);
    }

    public LootDataResolver resolver() {
        return this.resolver;
    }

    public LootCollector setParams(LootContextParameterSet var0) {
        return new LootCollector(this.reporter, var0, this.resolver, this.visitedElements);
    }
}

