/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.ILightEngine;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineBlock;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import net.minecraft.world.level.lighting.LightEngineSky;
import net.minecraft.world.level.lighting.LightEngineStorage;

public class LevelLightEngine
implements ILightEngine {
    public static final int LIGHT_SECTION_PADDING = 1;
    protected final LevelHeightAccessor levelHeightAccessor;
    @Nullable
    private final LightEngine<?, ?> blockEngine;
    @Nullable
    private final LightEngine<?, ?> skyEngine;

    public LevelLightEngine(ILightAccess var0, boolean var1, boolean var2) {
        this.levelHeightAccessor = var0.getLevel();
        this.blockEngine = var1 ? new LightEngineBlock(var0) : null;
        this.skyEngine = var2 ? new LightEngineSky(var0) : null;
    }

    @Override
    public void checkBlock(BlockPosition var0) {
        if (this.blockEngine != null) {
            this.blockEngine.checkBlock(var0);
        }
        if (this.skyEngine != null) {
            this.skyEngine.checkBlock(var0);
        }
    }

    @Override
    public boolean hasLightWork() {
        if (this.skyEngine != null && this.skyEngine.hasLightWork()) {
            return true;
        }
        return this.blockEngine != null && this.blockEngine.hasLightWork();
    }

    @Override
    public int runLightUpdates() {
        int var0 = 0;
        if (this.blockEngine != null) {
            var0 += this.blockEngine.runLightUpdates();
        }
        if (this.skyEngine != null) {
            var0 += this.skyEngine.runLightUpdates();
        }
        return var0;
    }

    @Override
    public void updateSectionStatus(SectionPosition var0, boolean var1) {
        if (this.blockEngine != null) {
            this.blockEngine.updateSectionStatus(var0, var1);
        }
        if (this.skyEngine != null) {
            this.skyEngine.updateSectionStatus(var0, var1);
        }
    }

    @Override
    public void setLightEnabled(ChunkCoordIntPair var0, boolean var1) {
        if (this.blockEngine != null) {
            this.blockEngine.setLightEnabled(var0, var1);
        }
        if (this.skyEngine != null) {
            this.skyEngine.setLightEnabled(var0, var1);
        }
    }

    @Override
    public void propagateLightSources(ChunkCoordIntPair var0) {
        if (this.blockEngine != null) {
            this.blockEngine.propagateLightSources(var0);
        }
        if (this.skyEngine != null) {
            this.skyEngine.propagateLightSources(var0);
        }
    }

    public LightEngineLayerEventListener getLayerListener(EnumSkyBlock var0) {
        if (var0 == EnumSkyBlock.BLOCK) {
            if (this.blockEngine == null) {
                return LightEngineLayerEventListener.Void.INSTANCE;
            }
            return this.blockEngine;
        }
        if (this.skyEngine == null) {
            return LightEngineLayerEventListener.Void.INSTANCE;
        }
        return this.skyEngine;
    }

    public String getDebugData(EnumSkyBlock var0, SectionPosition var1) {
        if (var0 == EnumSkyBlock.BLOCK) {
            if (this.blockEngine != null) {
                return this.blockEngine.getDebugData(var1.asLong());
            }
        } else if (this.skyEngine != null) {
            return this.skyEngine.getDebugData(var1.asLong());
        }
        return "n/a";
    }

    public LightEngineStorage.b getDebugSectionType(EnumSkyBlock var0, SectionPosition var1) {
        if (var0 == EnumSkyBlock.BLOCK) {
            if (this.blockEngine != null) {
                return this.blockEngine.getDebugSectionType(var1.asLong());
            }
        } else if (this.skyEngine != null) {
            return this.skyEngine.getDebugSectionType(var1.asLong());
        }
        return LightEngineStorage.b.EMPTY;
    }

    public void queueSectionData(EnumSkyBlock var0, SectionPosition var1, @Nullable NibbleArray var2) {
        if (var0 == EnumSkyBlock.BLOCK) {
            if (this.blockEngine != null) {
                this.blockEngine.queueSectionData(var1.asLong(), var2);
            }
        } else if (this.skyEngine != null) {
            this.skyEngine.queueSectionData(var1.asLong(), var2);
        }
    }

    public void retainData(ChunkCoordIntPair var0, boolean var1) {
        if (this.blockEngine != null) {
            this.blockEngine.retainData(var0, var1);
        }
        if (this.skyEngine != null) {
            this.skyEngine.retainData(var0, var1);
        }
    }

    public int getRawBrightness(BlockPosition var0, int var1) {
        int var2 = this.skyEngine == null ? 0 : this.skyEngine.getLightValue(var0) - var1;
        int var3 = this.blockEngine == null ? 0 : this.blockEngine.getLightValue(var0);
        return Math.max(var3, var2);
    }

    public boolean lightOnInSection(SectionPosition var0) {
        long var1 = var0.asLong();
        return this.blockEngine == null || ((LightEngineStorage)this.blockEngine.storage).lightOnInSection(var1) && (this.skyEngine == null || ((LightEngineStorage)this.skyEngine.storage).lightOnInSection(var1));
    }

    public int getLightSectionCount() {
        return this.levelHeightAccessor.getSectionsCount() + 2;
    }

    public int getMinLightSection() {
        return this.levelHeightAccessor.getMinSection() - 1;
    }

    public int getMaxLightSection() {
        return this.getMinLightSection() + this.getLightSectionCount();
    }
}

