/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;

public class PersistentIndexed
extends PersistentBase {
    private static final String TAG_REMAINING_INDEXES = "Remaining";
    private static final String TAG_All_INDEXES = "All";
    private final LongSet all;
    private final LongSet remaining;

    public static PersistentBase.a<PersistentIndexed> factory() {
        return new PersistentBase.a<PersistentIndexed>(PersistentIndexed::new, PersistentIndexed::load, DataFixTypes.SAVED_DATA_STRUCTURE_FEATURE_INDICES);
    }

    private PersistentIndexed(LongSet var0, LongSet var1) {
        this.all = var0;
        this.remaining = var1;
    }

    public PersistentIndexed() {
        this((LongSet)new LongOpenHashSet(), (LongSet)new LongOpenHashSet());
    }

    public static PersistentIndexed load(NBTTagCompound var0) {
        return new PersistentIndexed((LongSet)new LongOpenHashSet(var0.getLongArray(TAG_All_INDEXES)), (LongSet)new LongOpenHashSet(var0.getLongArray(TAG_REMAINING_INDEXES)));
    }

    @Override
    public NBTTagCompound save(NBTTagCompound var0) {
        var0.putLongArray(TAG_All_INDEXES, this.all.toLongArray());
        var0.putLongArray(TAG_REMAINING_INDEXES, this.remaining.toLongArray());
        return var0;
    }

    public void addIndex(long var0) {
        this.all.add(var0);
        this.remaining.add(var0);
    }

    public boolean hasStartIndex(long var0) {
        return this.all.contains(var0);
    }

    public boolean hasUnhandledIndex(long var0) {
        return this.remaining.contains(var0);
    }

    public void removeIndex(long var0) {
        this.remaining.remove(var0);
    }

    public LongSet getAll() {
        return this.all;
    }
}

