/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureCircleConfiguration;

public class DiskFeature
extends WorldGenerator<WorldGenFeatureCircleConfiguration> {
    public DiskFeature(Codec<WorldGenFeatureCircleConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureCircleConfiguration> var0) {
        WorldGenFeatureCircleConfiguration var1 = var0.config();
        BlockPosition var2 = var0.origin();
        GeneratorAccessSeed var3 = var0.level();
        RandomSource var4 = var0.random();
        boolean var5 = false;
        int var6 = var2.getY();
        int var7 = var6 + var1.halfHeight();
        int var8 = var6 - var1.halfHeight() - 1;
        int var9 = var1.radius().sample(var4);
        BlockPosition.MutableBlockPosition var10 = new BlockPosition.MutableBlockPosition();
        for (BlockPosition var12 : BlockPosition.betweenClosed(var2.offset(-var9, 0, -var9), var2.offset(var9, 0, var9))) {
            int var14;
            int var13 = var12.getX() - var2.getX();
            if (var13 * var13 + (var14 = var12.getZ() - var2.getZ()) * var14 > var9 * var9) continue;
            var5 |= this.placeColumn(var1, var3, var4, var7, var8, var10.set(var12));
        }
        return var5;
    }

    protected boolean placeColumn(WorldGenFeatureCircleConfiguration var0, GeneratorAccessSeed var1, RandomSource var2, int var3, int var4, BlockPosition.MutableBlockPosition var5) {
        boolean var6 = false;
        for (int var7 = var3; var7 > var4; --var7) {
            var5.setY(var7);
            if (!var0.target().test(var1, var5)) continue;
            IBlockData var8 = var0.stateProvider().getState(var1, var2, var5);
            var1.setBlock(var5, var8, 2);
            this.markAboveForPostProcessing(var1, var5);
            var6 = true;
        }
        return var6;
    }
}

