/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class SurfaceSystem {
    private static final IBlockData WHITE_TERRACOTTA = Blocks.WHITE_TERRACOTTA.defaultBlockState();
    private static final IBlockData ORANGE_TERRACOTTA = Blocks.ORANGE_TERRACOTTA.defaultBlockState();
    private static final IBlockData TERRACOTTA = Blocks.TERRACOTTA.defaultBlockState();
    private static final IBlockData YELLOW_TERRACOTTA = Blocks.YELLOW_TERRACOTTA.defaultBlockState();
    private static final IBlockData BROWN_TERRACOTTA = Blocks.BROWN_TERRACOTTA.defaultBlockState();
    private static final IBlockData RED_TERRACOTTA = Blocks.RED_TERRACOTTA.defaultBlockState();
    private static final IBlockData LIGHT_GRAY_TERRACOTTA = Blocks.LIGHT_GRAY_TERRACOTTA.defaultBlockState();
    private static final IBlockData PACKED_ICE = Blocks.PACKED_ICE.defaultBlockState();
    private static final IBlockData SNOW_BLOCK = Blocks.SNOW_BLOCK.defaultBlockState();
    private final IBlockData defaultBlock;
    private final int seaLevel;
    private final IBlockData[] clayBands;
    private final NoiseGeneratorNormal clayBandsOffsetNoise;
    private final NoiseGeneratorNormal badlandsPillarNoise;
    private final NoiseGeneratorNormal badlandsPillarRoofNoise;
    private final NoiseGeneratorNormal badlandsSurfaceNoise;
    private final NoiseGeneratorNormal icebergPillarNoise;
    private final NoiseGeneratorNormal icebergPillarRoofNoise;
    private final NoiseGeneratorNormal icebergSurfaceNoise;
    private final PositionalRandomFactory noiseRandom;
    private final NoiseGeneratorNormal surfaceNoise;
    private final NoiseGeneratorNormal surfaceSecondaryNoise;

    public SurfaceSystem(RandomState var0, IBlockData var1, int var2, PositionalRandomFactory var3) {
        this.defaultBlock = var1;
        this.seaLevel = var2;
        this.noiseRandom = var3;
        this.clayBandsOffsetNoise = var0.getOrCreateNoise(Noises.CLAY_BANDS_OFFSET);
        this.clayBands = SurfaceSystem.generateBands(var3.fromHashOf(new MinecraftKey("clay_bands")));
        this.surfaceNoise = var0.getOrCreateNoise(Noises.SURFACE);
        this.surfaceSecondaryNoise = var0.getOrCreateNoise(Noises.SURFACE_SECONDARY);
        this.badlandsPillarNoise = var0.getOrCreateNoise(Noises.BADLANDS_PILLAR);
        this.badlandsPillarRoofNoise = var0.getOrCreateNoise(Noises.BADLANDS_PILLAR_ROOF);
        this.badlandsSurfaceNoise = var0.getOrCreateNoise(Noises.BADLANDS_SURFACE);
        this.icebergPillarNoise = var0.getOrCreateNoise(Noises.ICEBERG_PILLAR);
        this.icebergPillarRoofNoise = var0.getOrCreateNoise(Noises.ICEBERG_PILLAR_ROOF);
        this.icebergSurfaceNoise = var0.getOrCreateNoise(Noises.ICEBERG_SURFACE);
    }

    public void buildSurface(RandomState var0, BiomeManager var1, IRegistry<BiomeBase> var2, boolean var3, WorldGenerationContext var4, final IChunkAccess var5, NoiseChunk var6, SurfaceRules.o var7) {
        final BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition();
        final ChunkCoordIntPair var9 = var5.getPos();
        int var10 = var9.getMinBlockX();
        int var11 = var9.getMinBlockZ();
        BlockColumn var12 = new BlockColumn(){

            @Override
            public IBlockData getBlock(int var0) {
                return var5.getBlockState(var8.setY(var0));
            }

            @Override
            public void setBlock(int var0, IBlockData var1) {
                LevelHeightAccessor var2 = var5.getHeightAccessorForGeneration();
                if (var0 >= var2.getMinBuildHeight() && var0 < var2.getMaxBuildHeight()) {
                    var5.setBlockState(var8.setY(var0), var1, false);
                    if (!var1.getFluidState().isEmpty()) {
                        var5.markPosForPostprocessing(var8);
                    }
                }
            }

            public String toString() {
                return "ChunkBlockColumn " + var9;
            }
        };
        SurfaceRules.g var13 = new SurfaceRules.g(this, var0, var5, var6, var1::getBiome, var2, var4);
        SurfaceRules.u var14 = (SurfaceRules.u)var7.apply(var13);
        BlockPosition.MutableBlockPosition var15 = new BlockPosition.MutableBlockPosition();
        for (int var16 = 0; var16 < 16; ++var16) {
            for (int var17 = 0; var17 < 16; ++var17) {
                int var18 = var10 + var16;
                int var19 = var11 + var17;
                int var20 = var5.getHeight(HeightMap.Type.WORLD_SURFACE_WG, var16, var17) + 1;
                var8.setX(var18).setZ(var19);
                Holder<BiomeBase> var21 = var1.getBiome(var15.set(var18, var3 ? 0 : var20, var19));
                if (var21.is(Biomes.ERODED_BADLANDS)) {
                    this.erodedBadlandsExtension(var12, var18, var19, var20, var5);
                }
                int var22 = var5.getHeight(HeightMap.Type.WORLD_SURFACE_WG, var16, var17) + 1;
                var13.updateXZ(var18, var19);
                int var23 = 0;
                int var24 = Integer.MIN_VALUE;
                int var25 = Integer.MAX_VALUE;
                int var26 = var5.getMinBuildHeight();
                for (int var27 = var22; var27 >= var26; --var27) {
                    IBlockData var30;
                    int var29;
                    IBlockData var28 = var12.getBlock(var27);
                    if (var28.isAir()) {
                        var23 = 0;
                        var24 = Integer.MIN_VALUE;
                        continue;
                    }
                    if (!var28.getFluidState().isEmpty()) {
                        if (var24 != Integer.MIN_VALUE) continue;
                        var24 = var27 + 1;
                        continue;
                    }
                    if (var25 >= var27) {
                        var25 = DimensionManager.WAY_BELOW_MIN_Y;
                        for (var29 = var27 - 1; var29 >= var26 - 1; --var29) {
                            var30 = var12.getBlock(var29);
                            if (this.isStone(var30)) continue;
                            var25 = var29 + 1;
                            break;
                        }
                    }
                    var29 = var27 - var25 + 1;
                    var13.updateY(++var23, var29, var24, var18, var27, var19);
                    if (var28 != this.defaultBlock || (var30 = var14.tryApply(var18, var27, var19)) == null) continue;
                    var12.setBlock(var27, var30);
                }
                if (!var21.is(Biomes.FROZEN_OCEAN) && !var21.is(Biomes.DEEP_FROZEN_OCEAN)) continue;
                this.frozenOceanExtension(var13.getMinSurfaceLevel(), var21.value(), var12, var15, var18, var19, var20);
            }
        }
    }

    protected int getSurfaceDepth(int var0, int var1) {
        double var2 = this.surfaceNoise.getValue(var0, 0.0, var1);
        return (int)(var2 * 2.75 + 3.0 + this.noiseRandom.at(var0, 0, var1).nextDouble() * 0.25);
    }

    protected double getSurfaceSecondary(int var0, int var1) {
        return this.surfaceSecondaryNoise.getValue(var0, 0.0, var1);
    }

    private boolean isStone(IBlockData var0) {
        return !var0.isAir() && var0.getFluidState().isEmpty();
    }

    @Deprecated
    public Optional<IBlockData> topMaterial(SurfaceRules.o var0, CarvingContext var1, Function<BlockPosition, Holder<BiomeBase>> var2, IChunkAccess var3, NoiseChunk var4, BlockPosition var5, boolean var6) {
        SurfaceRules.g var7 = new SurfaceRules.g(this, var1.randomState(), var3, var4, var2, var1.registryAccess().registryOrThrow(Registries.BIOME), var1);
        SurfaceRules.u var8 = (SurfaceRules.u)var0.apply(var7);
        int var9 = var5.getX();
        int var10 = var5.getY();
        int var11 = var5.getZ();
        var7.updateXZ(var9, var11);
        var7.updateY(1, 1, var6 ? var10 + 1 : Integer.MIN_VALUE, var9, var10, var11);
        IBlockData var12 = var8.tryApply(var9, var10, var11);
        return Optional.ofNullable(var12);
    }

    private void erodedBadlandsExtension(BlockColumn var0, int var1, int var2, int var3, LevelHeightAccessor var4) {
        IBlockData var19;
        int var18;
        double var5 = 0.2;
        double var7 = Math.min(Math.abs(this.badlandsSurfaceNoise.getValue(var1, 0.0, var2) * 8.25), this.badlandsPillarNoise.getValue((double)var1 * 0.2, 0.0, (double)var2 * 0.2) * 15.0);
        if (var7 <= 0.0) {
            return;
        }
        double var9 = 0.75;
        double var11 = 1.5;
        double var13 = Math.abs(this.badlandsPillarRoofNoise.getValue((double)var1 * 0.75, 0.0, (double)var2 * 0.75) * 1.5);
        double var15 = 64.0 + Math.min(var7 * var7 * 2.5, Math.ceil(var13 * 50.0) + 24.0);
        int var17 = MathHelper.floor(var15);
        if (var3 > var17) {
            return;
        }
        for (var18 = var17; var18 >= var4.getMinBuildHeight() && !(var19 = var0.getBlock(var18)).is(this.defaultBlock.getBlock()); --var18) {
            if (!var19.is(Blocks.WATER)) continue;
            return;
        }
        for (var18 = var17; var18 >= var4.getMinBuildHeight() && var0.getBlock(var18).isAir(); --var18) {
            var0.setBlock(var18, this.defaultBlock);
        }
    }

    private void frozenOceanExtension(int var0, BiomeBase var1, BlockColumn var2, BlockPosition.MutableBlockPosition var3, int var4, int var5, int var6) {
        double var11;
        double var7 = 1.28;
        double var9 = Math.min(Math.abs(this.icebergSurfaceNoise.getValue(var4, 0.0, var5) * 8.25), this.icebergPillarNoise.getValue((double)var4 * 1.28, 0.0, (double)var5 * 1.28) * 15.0);
        if (var9 <= 1.8) {
            return;
        }
        double var13 = 1.17;
        double var15 = 1.5;
        double var17 = Math.abs(this.icebergPillarRoofNoise.getValue((double)var4 * 1.17, 0.0, (double)var5 * 1.17) * 1.5);
        double var19 = Math.min(var9 * var9 * 1.2, Math.ceil(var17 * 40.0) + 14.0);
        if (var1.shouldMeltFrozenOceanIcebergSlightly(var3.set(var4, 63, var5))) {
            var19 -= 2.0;
        }
        if (var19 > 2.0) {
            var11 = (double)this.seaLevel - var19 - 7.0;
            var19 += (double)this.seaLevel;
        } else {
            var19 = 0.0;
            var11 = 0.0;
        }
        double var21 = var19;
        RandomSource var23 = this.noiseRandom.at(var4, 0, var5);
        int var24 = 2 + var23.nextInt(4);
        int var25 = this.seaLevel + 18 + var23.nextInt(10);
        int var26 = 0;
        for (int var27 = Math.max(var6, (int)var21 + 1); var27 >= var0; --var27) {
            if (!(var2.getBlock(var27).isAir() && var27 < (int)var21 && var23.nextDouble() > 0.01) && (!var2.getBlock(var27).is(Blocks.WATER) || var27 <= (int)var11 || var27 >= this.seaLevel || var11 == 0.0 || !(var23.nextDouble() > 0.15))) continue;
            if (var26 <= var24 && var27 > var25) {
                var2.setBlock(var27, SNOW_BLOCK);
                ++var26;
                continue;
            }
            var2.setBlock(var27, PACKED_ICE);
        }
    }

    private static IBlockData[] generateBands(RandomSource var0) {
        int var2;
        Object[] var1 = new IBlockData[192];
        Arrays.fill(var1, TERRACOTTA);
        for (var2 = 0; var2 < var1.length; ++var2) {
            if ((var2 += var0.nextInt(5) + 1) >= var1.length) continue;
            var1[var2] = ORANGE_TERRACOTTA;
        }
        SurfaceSystem.makeBands(var0, (IBlockData[])var1, 1, YELLOW_TERRACOTTA);
        SurfaceSystem.makeBands(var0, (IBlockData[])var1, 2, BROWN_TERRACOTTA);
        SurfaceSystem.makeBands(var0, (IBlockData[])var1, 1, RED_TERRACOTTA);
        var2 = var0.nextIntBetweenInclusive(9, 15);
        int var3 = 0;
        for (int var4 = 0; var3 < var2 && var4 < var1.length; ++var3, var4 += var0.nextInt(16) + 4) {
            var1[var4] = WHITE_TERRACOTTA;
            if (var4 - 1 > 0 && var0.nextBoolean()) {
                var1[var4 - 1] = LIGHT_GRAY_TERRACOTTA;
            }
            if (var4 + 1 >= var1.length || !var0.nextBoolean()) continue;
            var1[var4 + 1] = LIGHT_GRAY_TERRACOTTA;
        }
        return var1;
    }

    private static void makeBands(RandomSource var0, IBlockData[] var1, int var2, IBlockData var3) {
        int var4 = var0.nextIntBetweenInclusive(6, 15);
        for (int var5 = 0; var5 < var4; ++var5) {
            int var6 = var2 + var0.nextInt(3);
            int var7 = var0.nextInt(var1.length);
            for (int var8 = 0; var7 + var8 < var1.length && var8 < var6; ++var8) {
                var1[var7 + var8] = var3;
            }
        }
    }

    protected IBlockData getBand(int var0, int var1, int var2) {
        int var3 = (int)Math.round(this.clayBandsOffsetNoise.getValue(var0, 0.0, var2) * 4.0);
        return this.clayBands[(var1 + var3 + this.clayBands.length) % this.clayBands.length];
    }
}

