/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.properties.BlockSetType;

public record BlockPropertyWood(String name, BlockSetType setType, SoundEffectType soundType, SoundEffectType hangingSignSoundType, SoundEffect fenceGateClose, SoundEffect fenceGateOpen) {
    private static final Map<String, BlockPropertyWood> TYPES = new Object2ObjectArrayMap();
    public static final Codec<BlockPropertyWood> CODEC = ExtraCodecs.stringResolverCodec(BlockPropertyWood::name, TYPES::get);
    public static final BlockPropertyWood OAK = BlockPropertyWood.register(new BlockPropertyWood("oak", BlockSetType.OAK));
    public static final BlockPropertyWood SPRUCE = BlockPropertyWood.register(new BlockPropertyWood("spruce", BlockSetType.SPRUCE));
    public static final BlockPropertyWood BIRCH = BlockPropertyWood.register(new BlockPropertyWood("birch", BlockSetType.BIRCH));
    public static final BlockPropertyWood ACACIA = BlockPropertyWood.register(new BlockPropertyWood("acacia", BlockSetType.ACACIA));
    public static final BlockPropertyWood CHERRY = BlockPropertyWood.register(new BlockPropertyWood("cherry", BlockSetType.CHERRY, SoundEffectType.CHERRY_WOOD, SoundEffectType.CHERRY_WOOD_HANGING_SIGN, SoundEffects.CHERRY_WOOD_FENCE_GATE_CLOSE, SoundEffects.CHERRY_WOOD_FENCE_GATE_OPEN));
    public static final BlockPropertyWood JUNGLE = BlockPropertyWood.register(new BlockPropertyWood("jungle", BlockSetType.JUNGLE));
    public static final BlockPropertyWood DARK_OAK = BlockPropertyWood.register(new BlockPropertyWood("dark_oak", BlockSetType.DARK_OAK));
    public static final BlockPropertyWood CRIMSON = BlockPropertyWood.register(new BlockPropertyWood("crimson", BlockSetType.CRIMSON, SoundEffectType.NETHER_WOOD, SoundEffectType.NETHER_WOOD_HANGING_SIGN, SoundEffects.NETHER_WOOD_FENCE_GATE_CLOSE, SoundEffects.NETHER_WOOD_FENCE_GATE_OPEN));
    public static final BlockPropertyWood WARPED = BlockPropertyWood.register(new BlockPropertyWood("warped", BlockSetType.WARPED, SoundEffectType.NETHER_WOOD, SoundEffectType.NETHER_WOOD_HANGING_SIGN, SoundEffects.NETHER_WOOD_FENCE_GATE_CLOSE, SoundEffects.NETHER_WOOD_FENCE_GATE_OPEN));
    public static final BlockPropertyWood MANGROVE = BlockPropertyWood.register(new BlockPropertyWood("mangrove", BlockSetType.MANGROVE));
    public static final BlockPropertyWood BAMBOO = BlockPropertyWood.register(new BlockPropertyWood("bamboo", BlockSetType.BAMBOO, SoundEffectType.BAMBOO_WOOD, SoundEffectType.BAMBOO_WOOD_HANGING_SIGN, SoundEffects.BAMBOO_WOOD_FENCE_GATE_CLOSE, SoundEffects.BAMBOO_WOOD_FENCE_GATE_OPEN));

    public BlockPropertyWood(String var0, BlockSetType var1) {
        this(var0, var1, SoundEffectType.WOOD, SoundEffectType.HANGING_SIGN, SoundEffects.FENCE_GATE_CLOSE, SoundEffects.FENCE_GATE_OPEN);
    }

    private static BlockPropertyWood register(BlockPropertyWood var0) {
        TYPES.put(var0.name(), var0);
        return var0;
    }

    public static Stream<BlockPropertyWood> values() {
        return TYPES.values().stream();
    }
}

