/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class TileEntityCommand
extends TileEntity {
    private boolean powered;
    private boolean auto;
    private boolean conditionMet;
    private final CommandBlockListenerAbstract commandBlock = new CommandBlockListenerAbstract(){

        @Override
        public void setCommand(String var0) {
            super.setCommand(var0);
            TileEntityCommand.this.setChanged();
        }

        @Override
        public WorldServer getLevel() {
            return (WorldServer)TileEntityCommand.this.level;
        }

        @Override
        public void onUpdated() {
            IBlockData var0 = TileEntityCommand.this.level.getBlockState(TileEntityCommand.this.worldPosition);
            this.getLevel().sendBlockUpdated(TileEntityCommand.this.worldPosition, var0, var0, 3);
        }

        @Override
        public Vec3D getPosition() {
            return Vec3D.atCenterOf(TileEntityCommand.this.worldPosition);
        }

        @Override
        public CommandListenerWrapper createCommandSourceStack() {
            EnumDirection var0 = TileEntityCommand.this.getBlockState().getValue(BlockCommand.FACING);
            return new CommandListenerWrapper(this, Vec3D.atCenterOf(TileEntityCommand.this.worldPosition), new Vec2F(0.0f, var0.toYRot()), this.getLevel(), 2, this.getName().getString(), this.getName(), this.getLevel().getServer(), null);
        }

        @Override
        public boolean isValid() {
            return !TileEntityCommand.this.isRemoved();
        }
    };

    public TileEntityCommand(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.COMMAND_BLOCK, var0, var1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        this.commandBlock.save(var0);
        var0.putBoolean("powered", this.isPowered());
        var0.putBoolean("conditionMet", this.wasConditionMet());
        var0.putBoolean("auto", this.isAutomatic());
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.commandBlock.load(var0);
        this.powered = var0.getBoolean("powered");
        this.conditionMet = var0.getBoolean("conditionMet");
        this.setAutomatic(var0.getBoolean("auto"));
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public CommandBlockListenerAbstract getCommandBlock() {
        return this.commandBlock;
    }

    public void setPowered(boolean var0) {
        this.powered = var0;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isAutomatic() {
        return this.auto;
    }

    public void setAutomatic(boolean var0) {
        boolean var1 = this.auto;
        this.auto = var0;
        if (!var1 && var0 && !this.powered && this.level != null && this.getMode() != Type.SEQUENCE) {
            this.scheduleTick();
        }
    }

    public void onModeSwitch() {
        Type var0 = this.getMode();
        if (var0 == Type.AUTO && (this.powered || this.auto) && this.level != null) {
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        Block var0 = this.getBlockState().getBlock();
        if (var0 instanceof BlockCommand) {
            this.markConditionMet();
            this.level.scheduleTick(this.worldPosition, var0, 1);
        }
    }

    public boolean wasConditionMet() {
        return this.conditionMet;
    }

    public boolean markConditionMet() {
        this.conditionMet = true;
        if (this.isConditional()) {
            TileEntity var1;
            BlockPosition var0 = this.worldPosition.relative(this.level.getBlockState(this.worldPosition).getValue(BlockCommand.FACING).getOpposite());
            this.conditionMet = this.level.getBlockState(var0).getBlock() instanceof BlockCommand ? (var1 = this.level.getBlockEntity(var0)) instanceof TileEntityCommand && ((TileEntityCommand)var1).getCommandBlock().getSuccessCount() > 0 : false;
        }
        return this.conditionMet;
    }

    public Type getMode() {
        IBlockData var0 = this.getBlockState();
        if (var0.is(Blocks.COMMAND_BLOCK)) {
            return Type.REDSTONE;
        }
        if (var0.is(Blocks.REPEATING_COMMAND_BLOCK)) {
            return Type.AUTO;
        }
        if (var0.is(Blocks.CHAIN_COMMAND_BLOCK)) {
            return Type.SEQUENCE;
        }
        return Type.REDSTONE;
    }

    public boolean isConditional() {
        IBlockData var0 = this.level.getBlockState(this.getBlockPos());
        if (var0.getBlock() instanceof BlockCommand) {
            return var0.getValue(BlockCommand.CONDITIONAL);
        }
        return false;
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type SEQUENCE = new Type();
        public static final /* enum */ Type AUTO = new Type();
        public static final /* enum */ Type REDSTONE = new Type();
        private static final /* synthetic */ Type[] d;

        public static Type[] values() {
            return (Type[])d.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{SEQUENCE, AUTO, REDSTONE};
        }

        static {
            d = Type.a();
        }
    }
}

