/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;

public class TrialSpawnerBlock
extends BlockTileEntity {
    public static final MapCodec<TrialSpawnerBlock> CODEC = TrialSpawnerBlock.simpleCodec(TrialSpawnerBlock::new);
    public static final BlockStateEnum<TrialSpawnerState> STATE = BlockProperties.TRIAL_SPAWNER_STATE;

    public MapCodec<TrialSpawnerBlock> codec() {
        return CODEC;
    }

    public TrialSpawnerBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(STATE, TrialSpawnerState.INACTIVE));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(STATE);
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TrialSpawnerBlockEntity(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var02, IBlockData var12, TileEntityTypes<T> var22) {
        BlockEntityTicker<T> blockEntityTicker;
        if (var02 instanceof WorldServer) {
            WorldServer var32 = (WorldServer)var02;
            blockEntityTicker = TrialSpawnerBlock.createTickerHelper(var22, TileEntityTypes.TRIAL_SPAWNER, (var1, var2, var3, var4) -> var4.getTrialSpawner().tickServer(var32, var2));
        } else {
            blockEntityTicker = TrialSpawnerBlock.createTickerHelper(var22, TileEntityTypes.TRIAL_SPAWNER, (var0, var1, var2, var3) -> var3.getTrialSpawner().tickClient(var0, var1));
        }
        return blockEntityTicker;
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable IBlockAccess var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        Spawner.appendHoverText(var0, var2, "spawn_data");
    }
}

