/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;

public class CopperBulbBlock
extends Block {
    public static final MapCodec<CopperBulbBlock> CODEC = CopperBulbBlock.simpleCodec(CopperBulbBlock::new);
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean LIT = BlockProperties.LIT;

    protected MapCodec<? extends CopperBulbBlock> codec() {
        return CODEC;
    }

    public CopperBulbBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.defaultBlockState().setValue(LIT, false)).setValue(POWERED, false));
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.getBlock() != var0.getBlock() && var1 instanceof WorldServer) {
            WorldServer var5 = (WorldServer)var1;
            this.checkAndFlip(var0, var5, var2);
        }
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        if (var1 instanceof WorldServer) {
            WorldServer var6 = (WorldServer)var1;
            this.checkAndFlip(var0, var6, var2);
        }
    }

    public void checkAndFlip(IBlockData var0, WorldServer var1, BlockPosition var2) {
        boolean var3 = var1.hasNeighborSignal(var2);
        if (var3 == var0.getValue(POWERED)) {
            return;
        }
        IBlockData var4 = var0;
        if (!var0.getValue(POWERED).booleanValue()) {
            var1.playSound(null, var2, (var4 = (IBlockData)var4.cycle(LIT)).getValue(LIT) != false ? SoundEffects.COPPER_BULB_TURN_ON : SoundEffects.COPPER_BULB_TURN_OFF, SoundCategory.BLOCKS);
        }
        var1.setBlock(var2, (IBlockData)var4.setValue(POWERED, var3), 3);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(LIT, POWERED);
    }

    @Override
    public boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return var1.getBlockState(var2).getValue(LIT) != false ? 15 : 0;
    }
}

