/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.BlockNetherVinesUtil;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockWeepingVines
extends BlockGrowingTop {
    public static final MapCodec<BlockWeepingVines> CODEC = BlockWeepingVines.simpleCodec(BlockWeepingVines::new);
    protected static final VoxelShape SHAPE = Block.box(4.0, 9.0, 4.0, 12.0, 16.0, 12.0);

    public MapCodec<BlockWeepingVines> codec() {
        return CODEC;
    }

    public BlockWeepingVines(BlockBase.Info var0) {
        super(var0, EnumDirection.DOWN, SHAPE, false, 0.1);
    }

    @Override
    protected int getBlocksToGrowWhenBonemealed(RandomSource var0) {
        return BlockNetherVinesUtil.getBlocksToGrowWhenBonemealed(var0);
    }

    @Override
    protected Block getBodyBlock() {
        return Blocks.WEEPING_VINES_PLANT;
    }

    @Override
    protected boolean canGrowInto(IBlockData var0) {
        return BlockNetherVinesUtil.isValidGrowthState(var0);
    }
}

