/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class BlockTall
extends Block
implements IBlockWaterlogged {
    public static final BlockStateBoolean NORTH = BlockSprawling.NORTH;
    public static final BlockStateBoolean EAST = BlockSprawling.EAST;
    public static final BlockStateBoolean SOUTH = BlockSprawling.SOUTH;
    public static final BlockStateBoolean WEST = BlockSprawling.WEST;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockSprawling.PROPERTY_BY_DIRECTION.entrySet().stream().filter(var0 -> ((EnumDirection)var0.getKey()).getAxis().isHorizontal()).collect(SystemUtils.toMap());
    protected final VoxelShape[] collisionShapeByIndex;
    protected final VoxelShape[] shapeByIndex;
    private final Object2IntMap<IBlockData> stateToIndex = new Object2IntOpenHashMap();

    protected BlockTall(float var0, float var1, float var2, float var3, float var4, BlockBase.Info var5) {
        super(var5);
        this.collisionShapeByIndex = this.makeShapes(var0, var1, var4, 0.0f, var4);
        this.shapeByIndex = this.makeShapes(var0, var1, var2, 0.0f, var3);
        for (IBlockData var7 : this.stateDefinition.getPossibleStates()) {
            this.getAABBIndex(var7);
        }
    }

    protected abstract MapCodec<? extends BlockTall> codec();

    protected VoxelShape[] makeShapes(float var0, float var1, float var2, float var3, float var4) {
        float var5 = 8.0f - var0;
        float var6 = 8.0f + var0;
        float var7 = 8.0f - var1;
        float var8 = 8.0f + var1;
        VoxelShape var9 = Block.box(var5, 0.0, var5, var6, var2, var6);
        VoxelShape var10 = Block.box(var7, var3, 0.0, var8, var4, var8);
        VoxelShape var11 = Block.box(var7, var3, var7, var8, var4, 16.0);
        VoxelShape var12 = Block.box(0.0, var3, var7, var8, var4, var8);
        VoxelShape var13 = Block.box(var7, var3, var7, 16.0, var4, var8);
        VoxelShape var14 = VoxelShapes.or(var10, var13);
        VoxelShape var15 = VoxelShapes.or(var11, var12);
        VoxelShape[] var16 = new VoxelShape[]{VoxelShapes.empty(), var11, var12, var15, var10, VoxelShapes.or(var11, var10), VoxelShapes.or(var12, var10), VoxelShapes.or(var15, var10), var13, VoxelShapes.or(var11, var13), VoxelShapes.or(var12, var13), VoxelShapes.or(var15, var13), var14, VoxelShapes.or(var11, var14), VoxelShapes.or(var12, var14), VoxelShapes.or(var15, var14)};
        for (int var17 = 0; var17 < 16; ++var17) {
            var16[var17] = VoxelShapes.or(var9, var16[var17]);
        }
        return var16;
    }

    @Override
    public boolean propagatesSkylightDown(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.getValue(WATERLOGGED) == false;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapeByIndex[this.getAABBIndex(var0)];
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.collisionShapeByIndex[this.getAABBIndex(var0)];
    }

    private static int indexFor(EnumDirection var0) {
        return 1 << var0.get2DDataValue();
    }

    protected int getAABBIndex(IBlockData var02) {
        return this.stateToIndex.computeIntIfAbsent((Object)var02, var0 -> {
            int var1 = 0;
            if (var0.getValue(NORTH).booleanValue()) {
                var1 |= BlockTall.indexFor(EnumDirection.NORTH);
            }
            if (var0.getValue(EAST).booleanValue()) {
                var1 |= BlockTall.indexFor(EnumDirection.EAST);
            }
            if (var0.getValue(SOUTH).booleanValue()) {
                var1 |= BlockTall.indexFor(EnumDirection.SOUTH);
            }
            if (var0.getValue(WEST).booleanValue()) {
                var1 |= BlockTall.indexFor(EnumDirection.WEST);
            }
            return var1;
        });
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            }
        }
        return var0;
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        switch (var1) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            }
        }
        return super.mirror(var0, var1);
    }
}

