/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockStem
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockStem> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ResourceKey.codec(Registries.BLOCK).fieldOf("fruit").forGetter(var0 -> var0.fruit), (App)ResourceKey.codec(Registries.BLOCK).fieldOf("attached_stem").forGetter(var0 -> var0.attachedStem), (App)ResourceKey.codec(Registries.ITEM).fieldOf("seed").forGetter(var0 -> var0.seed), BlockStem.propertiesCodec()).apply((Applicative)var02, BlockStem::new));
    public static final int MAX_AGE = 7;
    public static final BlockStateInteger AGE = BlockProperties.AGE_7;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box(7.0, 0.0, 7.0, 9.0, 2.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 4.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 6.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 8.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 10.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 12.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 14.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 9.0)};
    private final ResourceKey<Block> fruit;
    private final ResourceKey<Block> attachedStem;
    private final ResourceKey<Item> seed;

    public MapCodec<BlockStem> codec() {
        return CODEC;
    }

    protected BlockStem(ResourceKey<Block> var0, ResourceKey<Block> var1, ResourceKey<Item> var2, BlockBase.Info var3) {
        super(var3);
        this.fruit = var0;
        this.attachedStem = var1;
        this.seed = var2;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE_BY_AGE[var0.getValue(AGE)];
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.is(Blocks.FARMLAND);
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var1.getRawBrightness(var2, 0) < 9) {
            return;
        }
        float var4 = BlockCrops.getGrowthSpeed(this, var1, var2);
        if (var3.nextInt((int)(25.0f / var4) + 1) == 0) {
            int var5 = var0.getValue(AGE);
            if (var5 < 7) {
                var0 = (IBlockData)var0.setValue(AGE, var5 + 1);
                var1.setBlock(var2, var0, 2);
            } else {
                EnumDirection var6 = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var3);
                BlockPosition var7 = var2.relative(var6);
                IBlockData var8 = var1.getBlockState(var7.below());
                if (var1.getBlockState(var7).isAir() && (var8.is(Blocks.FARMLAND) || var8.is(TagsBlock.DIRT))) {
                    IRegistry<Block> var9 = var1.registryAccess().registryOrThrow(Registries.BLOCK);
                    Optional<Block> var10 = var9.getOptional(this.fruit);
                    Optional<Block> var11 = var9.getOptional(this.attachedStem);
                    if (var10.isPresent() && var11.isPresent()) {
                        var1.setBlockAndUpdate(var7, var10.get().defaultBlockState());
                        var1.setBlockAndUpdate(var2, (IBlockData)var11.get().defaultBlockState().setValue(BlockFacingHorizontal.FACING, var6));
                    }
                }
            }
        }
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return new ItemStack((IMaterial)DataFixUtils.orElse(var0.registryAccess().registryOrThrow(Registries.ITEM).getOptional(this.seed), (Object)this));
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return var2.getValue(AGE) != 7;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        int var4 = Math.min(7, var3.getValue(AGE) + MathHelper.nextInt(var0.random, 2, 5));
        IBlockData var5 = (IBlockData)var3.setValue(AGE, var4);
        var0.setBlock(var2, var5, 2);
        if (var4 == 7) {
            var5.randomTick(var0, var2, var0.random);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }
}

