/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.pathfinder.PathMode;

public abstract class BlockSkullAbstract
extends BlockTileEntity
implements Equipable {
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private final BlockSkull.a type;

    public BlockSkullAbstract(BlockSkull.a var0, BlockBase.Info var1) {
        super(var1);
        this.type = var0;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWERED, false));
    }

    protected abstract MapCodec<? extends BlockSkullAbstract> codec();

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntitySkull(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        if (var0.isClientSide) {
            boolean var3;
            boolean bl = var3 = var1.is(Blocks.DRAGON_HEAD) || var1.is(Blocks.DRAGON_WALL_HEAD) || var1.is(Blocks.PIGLIN_HEAD) || var1.is(Blocks.PIGLIN_WALL_HEAD);
            if (var3) {
                return BlockSkullAbstract.createTickerHelper(var2, TileEntityTypes.SKULL, TileEntitySkull::animation);
            }
        }
        return null;
    }

    public BlockSkull.a getType() {
        return this.type;
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    @Override
    public EnumItemSlot getEquipmentSlot() {
        return EnumItemSlot.HEAD;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(POWERED);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(POWERED, var0.getLevel().hasNeighborSignal(var0.getClickedPos()));
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        if (var1.isClientSide) {
            return;
        }
        boolean var6 = var1.hasNeighborSignal(var2);
        if (var6 != var0.getValue(POWERED)) {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, var6), 2);
        }
    }
}

