/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockObserver;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockRedstoneWire
extends Block {
    public static final MapCodec<BlockRedstoneWire> CODEC = BlockRedstoneWire.simpleCodec(BlockRedstoneWire::new);
    public static final BlockStateEnum<BlockPropertyRedstoneSide> NORTH = BlockProperties.NORTH_REDSTONE;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> EAST = BlockProperties.EAST_REDSTONE;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> SOUTH = BlockProperties.SOUTH_REDSTONE;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> WEST = BlockProperties.WEST_REDSTONE;
    public static final BlockStateInteger POWER = BlockProperties.POWER;
    public static final Map<EnumDirection, BlockStateEnum<BlockPropertyRedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.NORTH, NORTH, (Object)EnumDirection.EAST, EAST, (Object)EnumDirection.SOUTH, SOUTH, (Object)EnumDirection.WEST, WEST));
    protected static final int H = 1;
    protected static final int W = 3;
    protected static final int E = 13;
    protected static final int N = 3;
    protected static final int S = 13;
    private static final VoxelShape SHAPE_DOT = Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<EnumDirection, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.NORTH, (Object)Block.box(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)EnumDirection.SOUTH, (Object)Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)EnumDirection.EAST, (Object)Block.box(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)EnumDirection.WEST, (Object)Block.box(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<EnumDirection, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.NORTH, (Object)VoxelShapes.or(SHAPES_FLOOR.get(EnumDirection.NORTH), Block.box(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)EnumDirection.SOUTH, (Object)VoxelShapes.or(SHAPES_FLOOR.get(EnumDirection.SOUTH), Block.box(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)EnumDirection.EAST, (Object)VoxelShapes.or(SHAPES_FLOOR.get(EnumDirection.EAST), Block.box(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)EnumDirection.WEST, (Object)VoxelShapes.or(SHAPES_FLOOR.get(EnumDirection.WEST), Block.box(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private static final Map<IBlockData, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private static final Vec3D[] COLORS = SystemUtils.make(new Vec3D[16], var0 -> {
        for (int var1 = 0; var1 <= 15; ++var1) {
            float var2;
            float var3 = var2 * 0.6f + ((var2 = (float)var1 / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float var4 = MathHelper.clamp(var2 * var2 * 0.7f - 0.5f, 0.0f, 1.0f);
            float var5 = MathHelper.clamp(var2 * var2 * 0.6f - 0.7f, 0.0f, 1.0f);
            var0[var1] = new Vec3D(var3, var4, var5);
        }
    });
    private static final float PARTICLE_DENSITY = 0.2f;
    private final IBlockData crossState;
    private boolean shouldSignal = true;

    public MapCodec<BlockRedstoneWire> codec() {
        return CODEC;
    }

    public BlockRedstoneWire(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(NORTH, BlockPropertyRedstoneSide.NONE)).setValue(EAST, BlockPropertyRedstoneSide.NONE)).setValue(SOUTH, BlockPropertyRedstoneSide.NONE)).setValue(WEST, BlockPropertyRedstoneSide.NONE)).setValue(POWER, 0));
        this.crossState = (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(NORTH, BlockPropertyRedstoneSide.SIDE)).setValue(EAST, BlockPropertyRedstoneSide.SIDE)).setValue(SOUTH, BlockPropertyRedstoneSide.SIDE)).setValue(WEST, BlockPropertyRedstoneSide.SIDE);
        for (IBlockData var2 : this.getStateDefinition().getPossibleStates()) {
            if (var2.getValue(POWER) != 0) continue;
            SHAPES_CACHE.put(var2, this.calculateShape(var2));
        }
    }

    private VoxelShape calculateShape(IBlockData var0) {
        VoxelShape var1 = SHAPE_DOT;
        for (EnumDirection var3 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPropertyRedstoneSide var4 = (BlockPropertyRedstoneSide)var0.getValue(PROPERTY_BY_DIRECTION.get(var3));
            if (var4 == BlockPropertyRedstoneSide.SIDE) {
                var1 = VoxelShapes.or(var1, SHAPES_FLOOR.get(var3));
                continue;
            }
            if (var4 != BlockPropertyRedstoneSide.UP) continue;
            var1 = VoxelShapes.or(var1, SHAPES_UP.get(var3));
        }
        return var1;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES_CACHE.get(var0.setValue(POWER, 0));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return this.getConnectionState(var0.getLevel(), this.crossState, var0.getClickedPos());
    }

    private IBlockData getConnectionState(IBlockAccess var0, IBlockData var1, BlockPosition var2) {
        boolean var9;
        boolean var3 = BlockRedstoneWire.isDot(var1);
        var1 = this.getMissingConnections(var0, (IBlockData)this.defaultBlockState().setValue(POWER, var1.getValue(POWER)), var2);
        if (var3 && BlockRedstoneWire.isDot(var1)) {
            return var1;
        }
        boolean var4 = var1.getValue(NORTH).isConnected();
        boolean var5 = var1.getValue(SOUTH).isConnected();
        boolean var6 = var1.getValue(EAST).isConnected();
        boolean var7 = var1.getValue(WEST).isConnected();
        boolean var8 = !var4 && !var5;
        boolean bl = var9 = !var6 && !var7;
        if (!var7 && var8) {
            var1 = (IBlockData)var1.setValue(WEST, BlockPropertyRedstoneSide.SIDE);
        }
        if (!var6 && var8) {
            var1 = (IBlockData)var1.setValue(EAST, BlockPropertyRedstoneSide.SIDE);
        }
        if (!var4 && var9) {
            var1 = (IBlockData)var1.setValue(NORTH, BlockPropertyRedstoneSide.SIDE);
        }
        if (!var5 && var9) {
            var1 = (IBlockData)var1.setValue(SOUTH, BlockPropertyRedstoneSide.SIDE);
        }
        return var1;
    }

    private IBlockData getMissingConnections(IBlockAccess var0, IBlockData var1, BlockPosition var2) {
        boolean var3 = !var0.getBlockState(var2.above()).isRedstoneConductor(var0, var2);
        for (EnumDirection var5 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (((BlockPropertyRedstoneSide)var1.getValue(PROPERTY_BY_DIRECTION.get(var5))).isConnected()) continue;
            BlockPropertyRedstoneSide var6 = this.getConnectingSide(var0, var2, var5, var3);
            var1 = (IBlockData)var1.setValue(PROPERTY_BY_DIRECTION.get(var5), var6);
        }
        return var1;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.DOWN) {
            if (!this.canSurviveOn(var3, var5, var2)) {
                return Blocks.AIR.defaultBlockState();
            }
            return var0;
        }
        if (var1 == EnumDirection.UP) {
            return this.getConnectionState(var3, var0, var4);
        }
        BlockPropertyRedstoneSide var6 = this.getConnectingSide(var3, var4, var1);
        if (var6.isConnected() == ((BlockPropertyRedstoneSide)var0.getValue(PROPERTY_BY_DIRECTION.get(var1))).isConnected() && !BlockRedstoneWire.isCross(var0)) {
            return (IBlockData)var0.setValue(PROPERTY_BY_DIRECTION.get(var1), var6);
        }
        return this.getConnectionState(var3, (IBlockData)((IBlockData)this.crossState.setValue(POWER, var0.getValue(POWER))).setValue(PROPERTY_BY_DIRECTION.get(var1), var6), var4);
    }

    private static boolean isCross(IBlockData var0) {
        return var0.getValue(NORTH).isConnected() && var0.getValue(SOUTH).isConnected() && var0.getValue(EAST).isConnected() && var0.getValue(WEST).isConnected();
    }

    private static boolean isDot(IBlockData var0) {
        return !var0.getValue(NORTH).isConnected() && !var0.getValue(SOUTH).isConnected() && !var0.getValue(EAST).isConnected() && !var0.getValue(WEST).isConnected();
    }

    @Override
    public void updateIndirectNeighbourShapes(IBlockData var0, GeneratorAccess var1, BlockPosition var2, int var3, int var4) {
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var7 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            Object var10;
            BlockPropertyRedstoneSide var8 = (BlockPropertyRedstoneSide)var0.getValue(PROPERTY_BY_DIRECTION.get(var7));
            if (var8 == BlockPropertyRedstoneSide.NONE || var1.getBlockState(var5.setWithOffset((BaseBlockPosition)var2, var7)).is(this)) continue;
            var5.move(EnumDirection.DOWN);
            IBlockData var9 = var1.getBlockState(var5);
            if (var9.is(this)) {
                var10 = var5.relative(var7.getOpposite());
                var1.neighborShapeChanged(var7.getOpposite(), var1.getBlockState((BlockPosition)var10), var5, (BlockPosition)var10, var3, var4);
            }
            var5.setWithOffset((BaseBlockPosition)var2, var7).move(EnumDirection.UP);
            var10 = var1.getBlockState(var5);
            if (!((BlockBase.BlockData)var10).is(this)) continue;
            BaseBlockPosition var11 = var5.relative(var7.getOpposite());
            var1.neighborShapeChanged(var7.getOpposite(), var1.getBlockState((BlockPosition)var11), var5, (BlockPosition)var11, var3, var4);
        }
    }

    private BlockPropertyRedstoneSide getConnectingSide(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        return this.getConnectingSide(var0, var1, var2, !var0.getBlockState(var1.above()).isRedstoneConductor(var0, var1));
    }

    private BlockPropertyRedstoneSide getConnectingSide(IBlockAccess var0, BlockPosition var1, EnumDirection var2, boolean var3) {
        BlockPosition var4 = var1.relative(var2);
        IBlockData var5 = var0.getBlockState(var4);
        if (var3) {
            boolean var6;
            boolean bl = var6 = var5.getBlock() instanceof BlockTrapdoor || this.canSurviveOn(var0, var4, var5);
            if (var6 && BlockRedstoneWire.shouldConnectTo(var0.getBlockState(var4.above()))) {
                if (var5.isFaceSturdy(var0, var4, var2.getOpposite())) {
                    return BlockPropertyRedstoneSide.UP;
                }
                return BlockPropertyRedstoneSide.SIDE;
            }
        }
        if (BlockRedstoneWire.shouldConnectTo(var5, var2) || !var5.isRedstoneConductor(var0, var4) && BlockRedstoneWire.shouldConnectTo(var0.getBlockState(var4.below()))) {
            return BlockPropertyRedstoneSide.SIDE;
        }
        return BlockPropertyRedstoneSide.NONE;
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        IBlockData var4 = var1.getBlockState(var3);
        return this.canSurviveOn(var1, var3, var4);
    }

    private boolean canSurviveOn(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return var2.isFaceSturdy(var0, var1, EnumDirection.UP) || var2.is(Blocks.HOPPER);
    }

    private void updatePowerStrength(World var0, BlockPosition var1, IBlockData var2) {
        int var3 = this.calculateTargetStrength(var0, var1);
        if (var2.getValue(POWER) != var3) {
            if (var0.getBlockState(var1) == var2) {
                var0.setBlock(var1, (IBlockData)var2.setValue(POWER, var3), 2);
            }
            HashSet var4 = Sets.newHashSet();
            var4.add(var1);
            for (EnumDirection var8 : EnumDirection.values()) {
                var4.add(var1.relative(var8));
            }
            for (BlockPosition var6 : var4) {
                var0.updateNeighborsAt(var6, this);
            }
        }
    }

    private int calculateTargetStrength(World var0, BlockPosition var1) {
        this.shouldSignal = false;
        int var2 = var0.getBestNeighborSignal(var1);
        this.shouldSignal = true;
        int var3 = 0;
        if (var2 < 15) {
            for (EnumDirection var5 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                BlockPosition var6 = var1.relative(var5);
                IBlockData var7 = var0.getBlockState(var6);
                var3 = Math.max(var3, this.getWireSignal(var7));
                BlockPosition var8 = var1.above();
                if (var7.isRedstoneConductor(var0, var6) && !var0.getBlockState(var8).isRedstoneConductor(var0, var8)) {
                    var3 = Math.max(var3, this.getWireSignal(var0.getBlockState(var6.above())));
                    continue;
                }
                if (var7.isRedstoneConductor(var0, var6)) continue;
                var3 = Math.max(var3, this.getWireSignal(var0.getBlockState(var6.below())));
            }
        }
        return Math.max(var2, var3 - 1);
    }

    private int getWireSignal(IBlockData var0) {
        return var0.is(this) ? var0.getValue(POWER) : 0;
    }

    private void checkCornerChangeAt(World var0, BlockPosition var1) {
        if (!var0.getBlockState(var1).is(this)) {
            return;
        }
        var0.updateNeighborsAt(var1, this);
        for (EnumDirection var5 : EnumDirection.values()) {
            var0.updateNeighborsAt(var1.relative(var5), this);
        }
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock()) || var1.isClientSide) {
            return;
        }
        this.updatePowerStrength(var1, var2, var0);
        for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.VERTICAL) {
            var1.updateNeighborsAt(var2.relative(var6), this);
        }
        this.updateNeighborsOfNeighboringWires(var1, var2);
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var4 || var0.is(var3.getBlock())) {
            return;
        }
        super.onRemove(var0, var1, var2, var3, var4);
        if (var1.isClientSide) {
            return;
        }
        for (EnumDirection var8 : EnumDirection.values()) {
            var1.updateNeighborsAt(var2.relative(var8), this);
        }
        this.updatePowerStrength(var1, var2, var0);
        this.updateNeighborsOfNeighboringWires(var1, var2);
    }

    private void updateNeighborsOfNeighboringWires(World var0, BlockPosition var1) {
        for (EnumDirection var3 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            this.checkCornerChangeAt(var0, var1.relative(var3));
        }
        for (EnumDirection var3 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var4 = var1.relative(var3);
            if (var0.getBlockState(var4).isRedstoneConductor(var0, var4)) {
                this.checkCornerChangeAt(var0, var4.above());
                continue;
            }
            this.checkCornerChangeAt(var0, var4.below());
        }
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        if (var1.isClientSide) {
            return;
        }
        if (var0.canSurvive(var1, var2)) {
            this.updatePowerStrength(var1, var2, var0);
        } else {
            BlockRedstoneWire.dropResources(var0, var1, var2);
            var1.removeBlock(var2, false);
        }
    }

    @Override
    public int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (!this.shouldSignal) {
            return 0;
        }
        return var0.getSignal(var1, var2, var3);
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (!this.shouldSignal || var3 == EnumDirection.DOWN) {
            return 0;
        }
        int var4 = var0.getValue(POWER);
        if (var4 == 0) {
            return 0;
        }
        if (var3 == EnumDirection.UP || ((BlockPropertyRedstoneSide)this.getConnectionState(var1, var0, var2).getValue(PROPERTY_BY_DIRECTION.get(var3.getOpposite()))).isConnected()) {
            return var4;
        }
        return 0;
    }

    protected static boolean shouldConnectTo(IBlockData var0) {
        return BlockRedstoneWire.shouldConnectTo(var0, null);
    }

    protected static boolean shouldConnectTo(IBlockData var0, @Nullable EnumDirection var1) {
        if (var0.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (var0.is(Blocks.REPEATER)) {
            EnumDirection var2 = var0.getValue(BlockRepeater.FACING);
            return var2 == var1 || var2.getOpposite() == var1;
        }
        if (var0.is(Blocks.OBSERVER)) {
            return var1 == var0.getValue(BlockObserver.FACING);
        }
        return var0.isSignalSource() && var1 != null;
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return this.shouldSignal;
    }

    public static int getColorForPower(int var0) {
        Vec3D var1 = COLORS[var0];
        return MathHelper.color((float)var1.x(), (float)var1.y(), (float)var1.z());
    }

    private void spawnParticlesAlongLine(World var0, RandomSource var1, BlockPosition var2, Vec3D var3, EnumDirection var4, EnumDirection var5, float var6, float var7) {
        float var8 = var7 - var6;
        if (var1.nextFloat() >= 0.2f * var8) {
            return;
        }
        float var9 = 0.4375f;
        float var10 = var6 + var8 * var1.nextFloat();
        double var11 = 0.5 + (double)(0.4375f * (float)var4.getStepX()) + (double)(var10 * (float)var5.getStepX());
        double var13 = 0.5 + (double)(0.4375f * (float)var4.getStepY()) + (double)(var10 * (float)var5.getStepY());
        double var15 = 0.5 + (double)(0.4375f * (float)var4.getStepZ()) + (double)(var10 * (float)var5.getStepZ());
        var0.addParticle(new ParticleParamRedstone(var3.toVector3f(), 1.0f), (double)var2.getX() + var11, (double)var2.getY() + var13, (double)var2.getZ() + var15, 0.0, 0.0, 0.0);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        int var4 = var0.getValue(POWER);
        if (var4 == 0) {
            return;
        }
        block4: for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPropertyRedstoneSide var7 = (BlockPropertyRedstoneSide)var0.getValue(PROPERTY_BY_DIRECTION.get(var6));
            switch (var7) {
                case UP: {
                    this.spawnParticlesAlongLine(var1, var3, var2, COLORS[var4], var6, EnumDirection.UP, -0.5f, 0.5f);
                }
                case SIDE: {
                    this.spawnParticlesAlongLine(var1, var3, var2, COLORS[var4], EnumDirection.DOWN, var6, 0.0f, 0.5f);
                    continue block4;
                }
            }
            this.spawnParticlesAlongLine(var1, var3, var2, COLORS[var4], EnumDirection.DOWN, var6, 0.0f, 0.3f);
        }
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            }
        }
        return var0;
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        switch (var1) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            }
        }
        return super.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(NORTH, EAST, SOUTH, WEST, POWER);
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (!var3.getAbilities().mayBuild) {
            return EnumInteractionResult.PASS;
        }
        if (BlockRedstoneWire.isCross(var0) || BlockRedstoneWire.isDot(var0)) {
            IBlockData var6 = BlockRedstoneWire.isCross(var0) ? this.defaultBlockState() : this.crossState;
            var6 = (IBlockData)var6.setValue(POWER, var0.getValue(POWER));
            if ((var6 = this.getConnectionState(var1, var6, var2)) != var0) {
                var1.setBlock(var2, var6, 3);
                this.updatesOnShapeChange(var1, var2, var0, var6);
                return EnumInteractionResult.SUCCESS;
            }
        }
        return EnumInteractionResult.PASS;
    }

    private void updatesOnShapeChange(World var0, BlockPosition var1, IBlockData var2, IBlockData var3) {
        for (EnumDirection var5 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var6 = var1.relative(var5);
            if (((BlockPropertyRedstoneSide)var2.getValue(PROPERTY_BY_DIRECTION.get(var5))).isConnected() == ((BlockPropertyRedstoneSide)var3.getValue(PROPERTY_BY_DIRECTION.get(var5))).isConnected() || !var0.getBlockState(var6).isRedstoneConductor(var0, var6)) continue;
            var0.updateNeighborsAtExceptFromFacing(var6, var3.getBlock(), var5.getOpposite());
        }
    }
}

