/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockNetherrack
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockNetherrack> CODEC = BlockNetherrack.simpleCodec(BlockNetherrack::new);

    public MapCodec<BlockNetherrack> codec() {
        return CODEC;
    }

    public BlockNetherrack(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        if (!var0.getBlockState(var1.above()).propagatesSkylightDown(var0, var1)) {
            return false;
        }
        for (BlockPosition var4 : BlockPosition.betweenClosed(var1.offset(-1, -1, -1), var1.offset(1, 1, 1))) {
            if (!var0.getBlockState(var4).is(TagsBlock.NYLIUM)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        boolean var4 = false;
        boolean var5 = false;
        for (BlockPosition var7 : BlockPosition.betweenClosed(var2.offset(-1, -1, -1), var2.offset(1, 1, 1))) {
            IBlockData var8 = var0.getBlockState(var7);
            if (var8.is(Blocks.WARPED_NYLIUM)) {
                var5 = true;
            }
            if (var8.is(Blocks.CRIMSON_NYLIUM)) {
                var4 = true;
            }
            if (!var5 || !var4) continue;
            break;
        }
        if (var5 && var4) {
            var0.setBlock(var2, var1.nextBoolean() ? Blocks.WARPED_NYLIUM.defaultBlockState() : Blocks.CRIMSON_NYLIUM.defaultBlockState(), 3);
        } else if (var5) {
            var0.setBlock(var2, Blocks.WARPED_NYLIUM.defaultBlockState(), 3);
        } else if (var4) {
            var0.setBlock(var2, Blocks.CRIMSON_NYLIUM.defaultBlockState(), 3);
        }
    }
}

