/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemRecord;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockJukeBox
extends BlockTileEntity {
    public static final MapCodec<BlockJukeBox> CODEC = BlockJukeBox.simpleCodec(BlockJukeBox::new);
    public static final BlockStateBoolean HAS_RECORD = BlockProperties.HAS_RECORD;

    public MapCodec<BlockJukeBox> codec() {
        return CODEC;
    }

    protected BlockJukeBox(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HAS_RECORD, false));
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        super.setPlacedBy(var0, var1, var2, var3, var4);
        NBTTagCompound var5 = ItemBlock.getBlockEntityData(var4);
        if (var5 != null && var5.contains("RecordItem")) {
            var0.setBlock(var1, (IBlockData)var2.setValue(HAS_RECORD, true), 2);
        }
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        TileEntity tileEntity;
        if (var0.getValue(HAS_RECORD).booleanValue() && (tileEntity = var1.getBlockEntity(var2)) instanceof TileEntityJukeBox) {
            TileEntityJukeBox var6 = (TileEntityJukeBox)tileEntity;
            var6.popOutRecord();
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof TileEntityJukeBox) {
            TileEntityJukeBox var5 = (TileEntityJukeBox)tileEntity;
            var5.popOutRecord();
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityJukeBox(var0, var1);
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        TileEntityJukeBox var4;
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof TileEntityJukeBox && (var4 = (TileEntityJukeBox)tileEntity).isRecordPlaying()) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        TileEntityJukeBox var3;
        Object object = var1.getBlockEntity(var2);
        if (object instanceof TileEntityJukeBox && (object = (var3 = (TileEntityJukeBox)object).getTheItem().getItem()) instanceof ItemRecord) {
            ItemRecord var4 = (ItemRecord)object;
            return var4.getAnalogOutput();
        }
        return 0;
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HAS_RECORD);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        if (var1.getValue(HAS_RECORD).booleanValue()) {
            return BlockJukeBox.createTickerHelper(var2, TileEntityTypes.JUKEBOX, TileEntityJukeBox::playRecordTick);
        }
        return null;
    }
}

