/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.BlockPropertyJigsawOrientation;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockJigsaw
extends Block
implements ITileEntity,
GameMasterBlock {
    public static final MapCodec<BlockJigsaw> CODEC = BlockJigsaw.simpleCodec(BlockJigsaw::new);
    public static final BlockStateEnum<BlockPropertyJigsawOrientation> ORIENTATION = BlockProperties.ORIENTATION;

    public MapCodec<BlockJigsaw> codec() {
        return CODEC;
    }

    protected BlockJigsaw(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(ORIENTATION, BlockPropertyJigsawOrientation.NORTH_UP));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(ORIENTATION);
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(ORIENTATION, var1.rotation().rotate(var0.getValue(ORIENTATION)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return (IBlockData)var0.setValue(ORIENTATION, var1.rotation().rotate(var0.getValue(ORIENTATION)));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var1 = var0.getClickedFace();
        EnumDirection var2 = var1.getAxis() == EnumDirection.EnumAxis.Y ? var0.getHorizontalDirection().getOpposite() : EnumDirection.UP;
        return (IBlockData)this.defaultBlockState().setValue(ORIENTATION, BlockPropertyJigsawOrientation.fromFrontAndTop(var1, var2));
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityJigsaw(var0, var1);
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        TileEntity var6 = var1.getBlockEntity(var2);
        if (var6 instanceof TileEntityJigsaw && var3.canUseGameMasterBlocks()) {
            var3.openJigsawBlock((TileEntityJigsaw)var6);
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public static boolean canAttach(DefinedStructure.BlockInfo var0, DefinedStructure.BlockInfo var1) {
        EnumDirection var2 = BlockJigsaw.getFrontFacing(var0.state());
        EnumDirection var3 = BlockJigsaw.getFrontFacing(var1.state());
        EnumDirection var4 = BlockJigsaw.getTopFacing(var0.state());
        EnumDirection var5 = BlockJigsaw.getTopFacing(var1.state());
        TileEntityJigsaw.JointType var6 = TileEntityJigsaw.JointType.byName(var0.nbt().getString("joint")).orElseGet(() -> var2.getAxis().isHorizontal() ? TileEntityJigsaw.JointType.ALIGNED : TileEntityJigsaw.JointType.ROLLABLE);
        boolean var7 = var6 == TileEntityJigsaw.JointType.ROLLABLE;
        return var2 == var3.getOpposite() && (var7 || var4 == var5) && var0.nbt().getString("target").equals(var1.nbt().getString("name"));
    }

    public static EnumDirection getFrontFacing(IBlockData var0) {
        return var0.getValue(ORIENTATION).front();
    }

    public static EnumDirection getTopFacing(IBlockData var0) {
        return var0.getValue(ORIENTATION).top();
    }
}

