/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public abstract class BlockBannerAbstract
extends BlockTileEntity {
    private final EnumColor color;

    protected BlockBannerAbstract(EnumColor var0, BlockBase.Info var1) {
        super(var1);
        this.color = var0;
    }

    protected abstract MapCodec<? extends BlockBannerAbstract> codec();

    @Override
    public boolean isPossibleToRespawnInThis(IBlockData var0) {
        return true;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityBanner(var0, var1, this.color);
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var12, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        if (var0.isClientSide) {
            var0.getBlockEntity(var12, TileEntityTypes.BANNER).ifPresent(var1 -> var1.fromItem(var4));
        } else if (var4.hasCustomHoverName()) {
            var0.getBlockEntity(var12, TileEntityTypes.BANNER).ifPresent(var1 -> var1.setCustomName(var4.getHoverName()));
        }
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        TileEntity var3 = var0.getBlockEntity(var1);
        if (var3 instanceof TileEntityBanner) {
            return ((TileEntityBanner)var3).getItem();
        }
        return super.getCloneItemStack(var0, var1, var2);
    }

    public EnumColor getColor() {
        return this.color;
    }
}

