/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;

public abstract class World
implements GeneratorAccess,
AutoCloseable {
    public static final Codec<ResourceKey<World>> RESOURCE_KEY_CODEC = ResourceKey.codec(Registries.DIMENSION);
    public static final ResourceKey<World> OVERWORLD = ResourceKey.create(Registries.DIMENSION, new MinecraftKey("overworld"));
    public static final ResourceKey<World> NETHER = ResourceKey.create(Registries.DIMENSION, new MinecraftKey("the_nether"));
    public static final ResourceKey<World> END = ResourceKey.create(Registries.DIMENSION, new MinecraftKey("the_end"));
    public static final int MAX_LEVEL_SIZE = 30000000;
    public static final int LONG_PARTICLE_CLIP_RANGE = 512;
    public static final int SHORT_PARTICLE_CLIP_RANGE = 32;
    public static final int MAX_BRIGHTNESS = 15;
    public static final int TICKS_PER_DAY = 24000;
    public static final int MAX_ENTITY_SPAWN_Y = 20000000;
    public static final int MIN_ENTITY_SPAWN_Y = -20000000;
    protected final List<TickingBlockEntity> blockEntityTickers = Lists.newArrayList();
    protected final NeighborUpdater neighborUpdater;
    private final List<TickingBlockEntity> pendingBlockEntityTickers = Lists.newArrayList();
    private boolean tickingBlockEntities;
    public final Thread thread;
    private final boolean isDebug;
    private int skyDarken;
    protected int randValue = RandomSource.create().nextInt();
    protected final int addend = 1013904223;
    protected float oRainLevel;
    public float rainLevel;
    protected float oThunderLevel;
    public float thunderLevel;
    public final RandomSource random = RandomSource.create();
    @Deprecated
    private final RandomSource threadSafeRandom = RandomSource.createThreadSafe();
    private final ResourceKey<DimensionManager> dimensionTypeId;
    private final Holder<DimensionManager> dimensionTypeRegistration;
    public final WorldDataMutable levelData;
    private final Supplier<GameProfilerFiller> profiler;
    public final boolean isClientSide;
    private final WorldBorder worldBorder;
    private final BiomeManager biomeManager;
    private final ResourceKey<World> dimension;
    private final IRegistryCustom registryAccess;
    private final DamageSources damageSources;
    private long subTickCount;

    protected World(WorldDataMutable var0, ResourceKey<World> var1, IRegistryCustom var2, Holder<DimensionManager> var3, Supplier<GameProfilerFiller> var4, boolean var5, boolean var6, long var7, int var9) {
        this.profiler = var4;
        this.levelData = var0;
        this.dimensionTypeRegistration = var3;
        this.dimensionTypeId = var3.unwrapKey().orElseThrow(() -> new IllegalArgumentException("Dimension must be registered, got " + var3));
        final DimensionManager var10 = var3.value();
        this.dimension = var1;
        this.isClientSide = var5;
        this.worldBorder = var10.coordinateScale() != 1.0 ? new WorldBorder(){

            @Override
            public double getCenterX() {
                return super.getCenterX() / var10.coordinateScale();
            }

            @Override
            public double getCenterZ() {
                return super.getCenterZ() / var10.coordinateScale();
            }
        } : new WorldBorder();
        this.thread = Thread.currentThread();
        this.biomeManager = new BiomeManager(this, var7);
        this.isDebug = var6;
        this.neighborUpdater = new CollectingNeighborUpdater(this, var9);
        this.registryAccess = var2;
        this.damageSources = new DamageSources(var2);
    }

    @Override
    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public boolean isInWorldBounds(BlockPosition var0) {
        return !this.isOutsideBuildHeight(var0) && World.isInWorldBoundsHorizontal(var0);
    }

    public static boolean isInSpawnableBounds(BlockPosition var0) {
        return !World.isOutsideSpawnableHeight(var0.getY()) && World.isInWorldBoundsHorizontal(var0);
    }

    private static boolean isInWorldBoundsHorizontal(BlockPosition var0) {
        return var0.getX() >= -30000000 && var0.getZ() >= -30000000 && var0.getX() < 30000000 && var0.getZ() < 30000000;
    }

    private static boolean isOutsideSpawnableHeight(int var0) {
        return var0 < -20000000 || var0 >= 20000000;
    }

    public Chunk getChunkAt(BlockPosition var0) {
        return this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    @Override
    public Chunk getChunk(int var0, int var1) {
        return (Chunk)this.getChunk(var0, var1, ChunkStatus.FULL);
    }

    @Override
    @Nullable
    public IChunkAccess getChunk(int var0, int var1, ChunkStatus var2, boolean var3) {
        IChunkAccess var4 = this.getChunkSource().getChunk(var0, var1, var2, var3);
        if (var4 == null && var3) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return var4;
    }

    @Override
    public boolean setBlock(BlockPosition var0, IBlockData var1, int var2) {
        return this.setBlock(var0, var1, var2, 512);
    }

    @Override
    public boolean setBlock(BlockPosition var0, IBlockData var1, int var2, int var3) {
        if (this.isOutsideBuildHeight(var0)) {
            return false;
        }
        if (!this.isClientSide && this.isDebug()) {
            return false;
        }
        Chunk var4 = this.getChunkAt(var0);
        Block var5 = var1.getBlock();
        IBlockData var6 = var4.setBlockState(var0, var1, (var2 & 0x40) != 0);
        if (var6 != null) {
            IBlockData var7 = this.getBlockState(var0);
            if (var7 == var1) {
                if (var6 != var7) {
                    this.setBlocksDirty(var0, var6, var7);
                }
                if ((var2 & 2) != 0 && (!this.isClientSide || (var2 & 4) == 0) && (this.isClientSide || var4.getFullStatus() != null && var4.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING))) {
                    this.sendBlockUpdated(var0, var6, var1, var2);
                }
                if ((var2 & 1) != 0) {
                    this.blockUpdated(var0, var6.getBlock());
                    if (!this.isClientSide && var1.hasAnalogOutputSignal()) {
                        this.updateNeighbourForOutputSignal(var0, var5);
                    }
                }
                if ((var2 & 0x10) == 0 && var3 > 0) {
                    int var8 = var2 & 0xFFFFFFDE;
                    var6.updateIndirectNeighbourShapes(this, var0, var8, var3 - 1);
                    var1.updateNeighbourShapes(this, var0, var8, var3 - 1);
                    var1.updateIndirectNeighbourShapes(this, var0, var8, var3 - 1);
                }
                this.onBlockStateChange(var0, var6, var7);
            }
            return true;
        }
        return false;
    }

    public void onBlockStateChange(BlockPosition var0, IBlockData var1, IBlockData var2) {
    }

    @Override
    public boolean removeBlock(BlockPosition var0, boolean var1) {
        Fluid var2 = this.getFluidState(var0);
        return this.setBlock(var0, var2.createLegacyBlock(), 3 | (var1 ? 64 : 0));
    }

    @Override
    public boolean destroyBlock(BlockPosition var0, boolean var1, @Nullable Entity var2, int var3) {
        boolean var6;
        IBlockData var4 = this.getBlockState(var0);
        if (var4.isAir()) {
            return false;
        }
        Fluid var5 = this.getFluidState(var0);
        if (!(var4.getBlock() instanceof BlockFireAbstract)) {
            this.levelEvent(2001, var0, Block.getId(var4));
        }
        if (var1) {
            TileEntity var62 = var4.hasBlockEntity() ? this.getBlockEntity(var0) : null;
            Block.dropResources(var4, this, var0, var62, var2, ItemStack.EMPTY);
        }
        if (var6 = this.setBlock(var0, var5.createLegacyBlock(), 3, var3)) {
            this.gameEvent(GameEvent.BLOCK_DESTROY, var0, GameEvent.a.of(var2, var4));
        }
        return var6;
    }

    public void addDestroyBlockEffect(BlockPosition var0, IBlockData var1) {
    }

    public boolean setBlockAndUpdate(BlockPosition var0, IBlockData var1) {
        return this.setBlock(var0, var1, 3);
    }

    public abstract void sendBlockUpdated(BlockPosition var1, IBlockData var2, IBlockData var3, int var4);

    public void setBlocksDirty(BlockPosition var0, IBlockData var1, IBlockData var2) {
    }

    public void updateNeighborsAt(BlockPosition var0, Block var1) {
    }

    public void updateNeighborsAtExceptFromFacing(BlockPosition var0, Block var1, EnumDirection var2) {
    }

    public void neighborChanged(BlockPosition var0, Block var1, BlockPosition var2) {
    }

    public void neighborChanged(IBlockData var0, BlockPosition var1, Block var2, BlockPosition var3, boolean var4) {
    }

    @Override
    public void neighborShapeChanged(EnumDirection var0, IBlockData var1, BlockPosition var2, BlockPosition var3, int var4, int var5) {
        this.neighborUpdater.shapeUpdate(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        int var3 = var1 < -30000000 || var2 < -30000000 || var1 >= 30000000 || var2 >= 30000000 ? this.getSeaLevel() + 1 : (this.hasChunk(SectionPosition.blockToSectionCoord(var1), SectionPosition.blockToSectionCoord(var2)) ? this.getChunk(SectionPosition.blockToSectionCoord(var1), SectionPosition.blockToSectionCoord(var2)).getHeight(var0, var1 & 0xF, var2 & 0xF) + 1 : this.getMinBuildHeight());
        return var3;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.getChunkSource().getLightEngine();
    }

    @Override
    public IBlockData getBlockState(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        Chunk var1 = this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
        return var1.getBlockState(var0);
    }

    @Override
    public Fluid getFluidState(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        Chunk var1 = this.getChunkAt(var0);
        return var1.getFluidState(var0);
    }

    public boolean isDay() {
        return !this.dimensionType().hasFixedTime() && this.skyDarken < 4;
    }

    public boolean isNight() {
        return !this.dimensionType().hasFixedTime() && !this.isDay();
    }

    public void playSound(@Nullable Entity var0, BlockPosition var1, SoundEffect var2, SoundCategory var3, float var4, float var5) {
        EntityHuman var6;
        this.playSound(var0 instanceof EntityHuman ? (var6 = (EntityHuman)var0) : null, var1, var2, var3, var4, var5);
    }

    @Override
    public void playSound(@Nullable EntityHuman var0, BlockPosition var1, SoundEffect var2, SoundCategory var3, float var4, float var5) {
        this.playSound(var0, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, var2, var3, var4, var5);
    }

    public abstract void playSeededSound(@Nullable EntityHuman var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void playSeededSound(@Nullable EntityHuman var0, double var1, double var3, double var5, SoundEffect var7, SoundCategory var8, float var9, float var10, long var11) {
        this.playSeededSound(var0, var1, var3, var5, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(var7), var8, var9, var10, var11);
    }

    public abstract void playSeededSound(@Nullable EntityHuman var1, Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void playSound(@Nullable EntityHuman var0, double var1, double var3, double var5, SoundEffect var7, SoundCategory var8) {
        this.playSound(var0, var1, var3, var5, var7, var8, 1.0f, 1.0f);
    }

    public void playSound(@Nullable EntityHuman var0, double var1, double var3, double var5, SoundEffect var7, SoundCategory var8, float var9, float var10) {
        this.playSeededSound(var0, var1, var3, var5, var7, var8, var9, var10, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable EntityHuman var0, Entity var1, SoundEffect var2, SoundCategory var3, float var4, float var5) {
        this.playSeededSound(var0, var1, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(var2), var3, var4, var5, this.threadSafeRandom.nextLong());
    }

    public void playLocalSound(BlockPosition var0, SoundEffect var1, SoundCategory var2, float var3, float var4, boolean var5) {
        this.playLocalSound((double)var0.getX() + 0.5, (double)var0.getY() + 0.5, (double)var0.getZ() + 0.5, var1, var2, var3, var4, var5);
    }

    public void playLocalSound(Entity var0, SoundEffect var1, SoundCategory var2, float var3, float var4) {
    }

    public void playLocalSound(double var0, double var2, double var4, SoundEffect var6, SoundCategory var7, float var8, float var9, boolean var10) {
    }

    @Override
    public void addParticle(ParticleParam var0, double var1, double var3, double var5, double var7, double var9, double var11) {
    }

    public void addParticle(ParticleParam var0, boolean var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    public void addAlwaysVisibleParticle(ParticleParam var0, double var1, double var3, double var5, double var7, double var9, double var11) {
    }

    public void addAlwaysVisibleParticle(ParticleParam var0, boolean var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    public float getSunAngle(float var0) {
        float var1 = this.getTimeOfDay(var0);
        return var1 * ((float)Math.PI * 2);
    }

    public void addBlockEntityTicker(TickingBlockEntity var0) {
        (this.tickingBlockEntities ? this.pendingBlockEntityTickers : this.blockEntityTickers).add(var0);
    }

    protected void tickBlockEntities() {
        GameProfilerFiller var0 = this.getProfiler();
        var0.push("blockEntities");
        this.tickingBlockEntities = true;
        if (!this.pendingBlockEntityTickers.isEmpty()) {
            this.blockEntityTickers.addAll(this.pendingBlockEntityTickers);
            this.pendingBlockEntityTickers.clear();
        }
        Iterator<TickingBlockEntity> var1 = this.blockEntityTickers.iterator();
        boolean var2 = this.tickRateManager().runsNormally();
        while (var1.hasNext()) {
            TickingBlockEntity var3 = var1.next();
            if (var3.isRemoved()) {
                var1.remove();
                continue;
            }
            if (!var2 || !this.shouldTickBlocksAt(var3.getPos())) continue;
            var3.tick();
        }
        this.tickingBlockEntities = false;
        var0.pop();
    }

    public <T extends Entity> void guardEntityTick(Consumer<T> var0, T var1) {
        try {
            var0.accept(var1);
        }
        catch (Throwable var2) {
            CrashReport var3 = CrashReport.forThrowable(var2, "Ticking entity");
            CrashReportSystemDetails var4 = var3.addCategory("Entity being ticked");
            var1.fillCrashReportCategory(var4);
            throw new ReportedException(var3);
        }
    }

    public boolean shouldTickDeath(Entity var0) {
        return true;
    }

    public boolean shouldTickBlocksAt(long var0) {
        return true;
    }

    public boolean shouldTickBlocksAt(BlockPosition var0) {
        return this.shouldTickBlocksAt(ChunkCoordIntPair.asLong(var0));
    }

    public Explosion explode(@Nullable Entity var0, double var1, double var3, double var5, float var7, a var8) {
        return this.explode(var0, Explosion.getDefaultDamageSource(this, var0), null, var1, var3, var5, var7, false, var8, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity var0, double var1, double var3, double var5, float var7, boolean var8, a var9) {
        return this.explode(var0, Explosion.getDefaultDamageSource(this, var0), null, var1, var3, var5, var7, var8, var9, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity var0, @Nullable DamageSource var1, @Nullable ExplosionDamageCalculator var2, Vec3D var3, float var4, boolean var5, a var6) {
        return this.explode(var0, var1, var2, var3.x(), var3.y(), var3.z(), var4, var5, var6, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity var0, @Nullable DamageSource var1, @Nullable ExplosionDamageCalculator var2, double var3, double var5, double var7, float var9, boolean var10, a var11) {
        return this.explode(var0, var1, var2, var3, var5, var7, var9, var10, var11, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity var0, @Nullable DamageSource var1, @Nullable ExplosionDamageCalculator var2, double var3, double var5, double var7, float var9, boolean var10, a var11, ParticleParam var12, ParticleParam var13, SoundEffect var14) {
        return this.explode(var0, var1, var2, var3, var5, var7, var9, var10, var11, true, var12, var13, var14);
    }

    public Explosion explode(@Nullable Entity var0, @Nullable DamageSource var1, @Nullable ExplosionDamageCalculator var2, double var3, double var5, double var7, float var9, boolean var10, a var11, boolean var12, ParticleParam var13, ParticleParam var14, SoundEffect var15) {
        Explosion.Effect var16 = switch (var11) {
            default -> throw new IncompatibleClassChangeError();
            case a.NONE -> Explosion.Effect.KEEP;
            case a.BLOCK -> this.getDestroyType(GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
            case a.MOB -> {
                if (this.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    yield this.getDestroyType(GameRules.RULE_MOB_EXPLOSION_DROP_DECAY);
                }
                yield Explosion.Effect.KEEP;
            }
            case a.TNT -> this.getDestroyType(GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
            case a.BLOW -> Explosion.Effect.TRIGGER_BLOCK;
        };
        Explosion var17 = new Explosion(this, var0, var1, var2, var3, var5, var7, var9, var10, var16, var13, var14, var15);
        var17.explode();
        var17.finalizeExplosion(var12);
        return var17;
    }

    private Explosion.Effect getDestroyType(GameRules.GameRuleKey<GameRules.GameRuleBoolean> var0) {
        return this.getGameRules().getBoolean(var0) ? Explosion.Effect.DESTROY_WITH_DECAY : Explosion.Effect.DESTROY;
    }

    public abstract String gatherChunkSourceStats();

    @Override
    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return null;
        }
        if (!this.isClientSide && Thread.currentThread() != this.thread) {
            return null;
        }
        return this.getChunkAt(var0).getBlockEntity(var0, Chunk.EnumTileEntityState.IMMEDIATE);
    }

    public void setBlockEntity(TileEntity var0) {
        BlockPosition var1 = var0.getBlockPos();
        if (this.isOutsideBuildHeight(var1)) {
            return;
        }
        this.getChunkAt(var1).addAndRegisterBlockEntity(var0);
    }

    public void removeBlockEntity(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return;
        }
        this.getChunkAt(var0).removeBlockEntity(var0);
    }

    public boolean isLoaded(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return false;
        }
        return this.getChunkSource().hasChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    public boolean loadedAndEntityCanStandOnFace(BlockPosition var0, Entity var1, EnumDirection var2) {
        if (this.isOutsideBuildHeight(var0)) {
            return false;
        }
        IChunkAccess var3 = this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()), ChunkStatus.FULL, false);
        if (var3 == null) {
            return false;
        }
        return var3.getBlockState(var0).entityCanStandOnFace(this, var0, var1, var2);
    }

    public boolean loadedAndEntityCanStandOn(BlockPosition var0, Entity var1) {
        return this.loadedAndEntityCanStandOnFace(var0, var1, EnumDirection.UP);
    }

    public void updateSkyBrightness() {
        double var0 = 1.0 - (double)(this.getRainLevel(1.0f) * 5.0f) / 16.0;
        double var2 = 1.0 - (double)(this.getThunderLevel(1.0f) * 5.0f) / 16.0;
        double var4 = 0.5 + 2.0 * MathHelper.clamp((double)MathHelper.cos(this.getTimeOfDay(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.skyDarken = (int)((1.0 - var4 * var0 * var2) * 11.0);
    }

    public void setSpawnSettings(boolean var0, boolean var1) {
        this.getChunkSource().setSpawnSettings(var0, var1);
    }

    public BlockPosition getSharedSpawnPos() {
        BlockPosition var0 = new BlockPosition(this.levelData.getXSpawn(), this.levelData.getYSpawn(), this.levelData.getZSpawn());
        if (!this.getWorldBorder().isWithinBounds(var0)) {
            var0 = this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, BlockPosition.containing(this.getWorldBorder().getCenterX(), 0.0, this.getWorldBorder().getCenterZ()));
        }
        return var0;
    }

    public float getSharedSpawnAngle() {
        return this.levelData.getSpawnAngle();
    }

    protected void prepareWeather() {
        if (this.levelData.isRaining()) {
            this.rainLevel = 1.0f;
            if (this.levelData.isThundering()) {
                this.thunderLevel = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getChunkSource().close();
    }

    @Override
    @Nullable
    public IBlockAccess getChunkForCollisions(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.FULL, false);
    }

    @Override
    public List<Entity> getEntities(@Nullable Entity var0, AxisAlignedBB var1, Predicate<? super Entity> var2) {
        this.getProfiler().incrementCounter("getEntities");
        ArrayList var32 = Lists.newArrayList();
        this.getEntities().get(var1, var3 -> {
            if (var3 != var0 && var2.test((Entity)var3)) {
                var32.add(var3);
            }
            if (var3 instanceof EntityEnderDragon) {
                for (EntityComplexPart var7 : ((EntityEnderDragon)var3).getSubEntities()) {
                    if (var3 == var0 || !var2.test(var7)) continue;
                    var32.add(var7);
                }
            }
        });
        return var32;
    }

    @Override
    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var0, AxisAlignedBB var1, Predicate<? super T> var2) {
        ArrayList var3 = Lists.newArrayList();
        this.getEntities(var0, var1, var2, var3);
        return var3;
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> var0, AxisAlignedBB var1, Predicate<? super T> var2, List<? super T> var3) {
        this.getEntities(var0, var1, var2, var3, Integer.MAX_VALUE);
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> var0, AxisAlignedBB var1, Predicate<? super T> var2, List<? super T> var3, int var42) {
        this.getProfiler().incrementCounter("getEntities");
        this.getEntities().get(var0, var1, var4 -> {
            if (var2.test(var4)) {
                var3.add((Object)var4);
                if (var3.size() >= var42) {
                    return AbortableIterationConsumer.a.ABORT;
                }
            }
            if (var4 instanceof EntityEnderDragon) {
                EntityEnderDragon var5 = (EntityEnderDragon)var4;
                for (EntityComplexPart var9 : var5.getSubEntities()) {
                    Entity var10 = (Entity)var0.tryCast(var9);
                    if (var10 == null || !var2.test(var10)) continue;
                    var3.add((Object)var10);
                    if (var3.size() < var42) continue;
                    return AbortableIterationConsumer.a.ABORT;
                }
            }
            return AbortableIterationConsumer.a.CONTINUE;
        });
    }

    @Nullable
    public abstract Entity getEntity(int var1);

    public void blockEntityChanged(BlockPosition var0) {
        if (this.hasChunkAt(var0)) {
            this.getChunkAt(var0).setUnsaved(true);
        }
    }

    @Override
    public int getSeaLevel() {
        return 63;
    }

    public void disconnect() {
    }

    public long getGameTime() {
        return this.levelData.getGameTime();
    }

    public long getDayTime() {
        return this.levelData.getDayTime();
    }

    public boolean mayInteract(EntityHuman var0, BlockPosition var1) {
        return true;
    }

    public void broadcastEntityEvent(Entity var0, byte var1) {
    }

    public void broadcastDamageEvent(Entity var0, DamageSource var1) {
    }

    public void blockEvent(BlockPosition var0, Block var1, int var2, int var3) {
        this.getBlockState(var0).triggerEvent(this, var0, var2, var3);
    }

    @Override
    public WorldData getLevelData() {
        return this.levelData;
    }

    public GameRules getGameRules() {
        return this.levelData.getGameRules();
    }

    public abstract TickRateManager tickRateManager();

    public float getThunderLevel(float var0) {
        return MathHelper.lerp(var0, this.oThunderLevel, this.thunderLevel) * this.getRainLevel(var0);
    }

    public void setThunderLevel(float var0) {
        float var1;
        this.oThunderLevel = var1 = MathHelper.clamp(var0, 0.0f, 1.0f);
        this.thunderLevel = var1;
    }

    public float getRainLevel(float var0) {
        return MathHelper.lerp(var0, this.oRainLevel, this.rainLevel);
    }

    public void setRainLevel(float var0) {
        float var1;
        this.oRainLevel = var1 = MathHelper.clamp(var0, 0.0f, 1.0f);
        this.rainLevel = var1;
    }

    public boolean isThundering() {
        if (!this.dimensionType().hasSkyLight() || this.dimensionType().hasCeiling()) {
            return false;
        }
        return (double)this.getThunderLevel(1.0f) > 0.9;
    }

    public boolean isRaining() {
        return (double)this.getRainLevel(1.0f) > 0.2;
    }

    public boolean isRainingAt(BlockPosition var0) {
        if (!this.isRaining()) {
            return false;
        }
        if (!this.canSeeSky(var0)) {
            return false;
        }
        if (this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, var0).getY() > var0.getY()) {
            return false;
        }
        BiomeBase var1 = this.getBiome(var0).value();
        return var1.getPrecipitationAt(var0) == BiomeBase.Precipitation.RAIN;
    }

    @Nullable
    public abstract WorldMap getMapData(String var1);

    public abstract void setMapData(String var1, WorldMap var2);

    public abstract int getFreeMapId();

    public void globalLevelEvent(int var0, BlockPosition var1, int var2) {
    }

    public CrashReportSystemDetails fillReportDetails(CrashReport var0) {
        CrashReportSystemDetails var1 = var0.addCategory("Affected level", 1);
        var1.setDetail("All players", () -> this.players().size() + " total; " + this.players());
        var1.setDetail("Chunk stats", this.getChunkSource()::gatherStats);
        var1.setDetail("Level dimension", () -> this.dimension().location().toString());
        try {
            this.levelData.fillCrashReportCategory(var1, this);
        }
        catch (Throwable var2) {
            var1.setDetailError("Level Data Unobtainable", var2);
        }
        return var1;
    }

    public abstract void destroyBlockProgress(int var1, BlockPosition var2, int var3);

    public void createFireworks(double var0, double var2, double var4, double var6, double var8, double var10, @Nullable NBTTagCompound var12) {
    }

    public abstract Scoreboard getScoreboard();

    public void updateNeighbourForOutputSignal(BlockPosition var0, Block var1) {
        for (EnumDirection var3 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var4 = var0.relative(var3);
            if (!this.hasChunkAt(var4)) continue;
            IBlockData var5 = this.getBlockState(var4);
            if (var5.is(Blocks.COMPARATOR)) {
                this.neighborChanged(var5, var4, var1, var0, false);
                continue;
            }
            if (!var5.isRedstoneConductor(this, var4) || !(var5 = this.getBlockState(var4 = var4.relative(var3))).is(Blocks.COMPARATOR)) continue;
            this.neighborChanged(var5, var4, var1, var0, false);
        }
    }

    @Override
    public DifficultyDamageScaler getCurrentDifficultyAt(BlockPosition var0) {
        long var1 = 0L;
        float var3 = 0.0f;
        if (this.hasChunkAt(var0)) {
            var3 = this.getMoonBrightness();
            var1 = this.getChunkAt(var0).getInhabitedTime();
        }
        return new DifficultyDamageScaler(this.getDifficulty(), this.getDayTime(), var1, var3);
    }

    @Override
    public int getSkyDarken() {
        return this.skyDarken;
    }

    public void setSkyFlashTime(int var0) {
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public void sendPacketToServer(Packet<?> var0) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager dimensionType() {
        return this.dimensionTypeRegistration.value();
    }

    public ResourceKey<DimensionManager> dimensionTypeId() {
        return this.dimensionTypeId;
    }

    public Holder<DimensionManager> dimensionTypeRegistration() {
        return this.dimensionTypeRegistration;
    }

    public ResourceKey<World> dimension() {
        return this.dimension;
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    @Override
    public boolean isStateAtPosition(BlockPosition var0, Predicate<IBlockData> var1) {
        return var1.test(this.getBlockState(var0));
    }

    @Override
    public boolean isFluidAtPosition(BlockPosition var0, Predicate<Fluid> var1) {
        return var1.test(this.getFluidState(var0));
    }

    public abstract CraftingManager getRecipeManager();

    public BlockPosition getBlockRandomPos(int var0, int var1, int var2, int var3) {
        this.randValue = this.randValue * 3 + 1013904223;
        int var4 = this.randValue >> 2;
        return new BlockPosition(var0 + (var4 & 0xF), var1 + (var4 >> 16 & var3), var2 + (var4 >> 8 & 0xF));
    }

    public boolean noSave() {
        return false;
    }

    public GameProfilerFiller getProfiler() {
        return this.profiler.get();
    }

    public Supplier<GameProfilerFiller> getProfilerSupplier() {
        return this.profiler;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    public abstract LevelEntityGetter<Entity> getEntities();

    @Override
    public long nextSubTickCount() {
        return this.subTickCount++;
    }

    @Override
    public IRegistryCustom registryAccess() {
        return this.registryAccess;
    }

    public DamageSources damageSources() {
        return this.damageSources;
    }

    @Override
    public /* synthetic */ IChunkAccess getChunk(int n2, int n3) {
        return this.getChunk(n2, n3);
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a NONE = new a();
        public static final /* enum */ a BLOCK = new a();
        public static final /* enum */ a MOB = new a();
        public static final /* enum */ a TNT = new a();
        public static final /* enum */ a BLOW = new a();
        private static final /* synthetic */ a[] f;

        public static a[] values() {
            return (a[])f.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{NONE, BLOCK, MOB, TNT, BLOW};
        }

        static {
            f = a.a();
        }
    }
}

