/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemFishingRod;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.ItemTrident;
import net.minecraft.world.item.ItemVanishable;
import net.minecraft.world.level.block.Block;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class EnchantmentSlotType
extends Enum<EnchantmentSlotType> {
    public static final /* enum */ EnchantmentSlotType ARMOR = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            return var0 instanceof ItemArmor;
        }
    };
    public static final /* enum */ EnchantmentSlotType ARMOR_FEET = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            ItemArmor var1;
            return var0 instanceof ItemArmor && (var1 = (ItemArmor)var0).getEquipmentSlot() == EnumItemSlot.FEET;
        }
    };
    public static final /* enum */ EnchantmentSlotType ARMOR_LEGS = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            ItemArmor var1;
            return var0 instanceof ItemArmor && (var1 = (ItemArmor)var0).getEquipmentSlot() == EnumItemSlot.LEGS;
        }
    };
    public static final /* enum */ EnchantmentSlotType ARMOR_CHEST = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            ItemArmor var1;
            return var0 instanceof ItemArmor && (var1 = (ItemArmor)var0).getEquipmentSlot() == EnumItemSlot.CHEST;
        }
    };
    public static final /* enum */ EnchantmentSlotType ARMOR_HEAD = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            ItemArmor var1;
            return var0 instanceof ItemArmor && (var1 = (ItemArmor)var0).getEquipmentSlot() == EnumItemSlot.HEAD;
        }
    };
    public static final /* enum */ EnchantmentSlotType WEAPON = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            return var0 instanceof ItemSword;
        }
    };
    public static final /* enum */ EnchantmentSlotType DIGGER = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            return var0 instanceof ItemTool;
        }
    };
    public static final /* enum */ EnchantmentSlotType FISHING_ROD = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            return var0 instanceof ItemFishingRod;
        }
    };
    public static final /* enum */ EnchantmentSlotType TRIDENT = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            return var0 instanceof ItemTrident;
        }
    };
    public static final /* enum */ EnchantmentSlotType BREAKABLE = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            return var0.canBeDepleted();
        }
    };
    public static final /* enum */ EnchantmentSlotType BOW = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            return var0 instanceof ItemBow;
        }
    };
    public static final /* enum */ EnchantmentSlotType WEARABLE = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            return var0 instanceof Equipable || Block.byItem(var0) instanceof Equipable;
        }
    };
    public static final /* enum */ EnchantmentSlotType CROSSBOW = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            return var0 instanceof ItemCrossbow;
        }
    };
    public static final /* enum */ EnchantmentSlotType VANISHABLE = new EnchantmentSlotType(){

        @Override
        public boolean canEnchant(Item var0) {
            return var0 instanceof ItemVanishable || Block.byItem(var0) instanceof ItemVanishable || BREAKABLE.canEnchant(var0);
        }
    };
    private static final /* synthetic */ EnchantmentSlotType[] o;

    public static EnchantmentSlotType[] values() {
        return (EnchantmentSlotType[])o.clone();
    }

    public static EnchantmentSlotType valueOf(String var0) {
        return Enum.valueOf(EnchantmentSlotType.class, var0);
    }

    public abstract boolean canEnchant(Item var1);

    private static /* synthetic */ EnchantmentSlotType[] a() {
        return new EnchantmentSlotType[]{ARMOR, ARMOR_FEET, ARMOR_LEGS, ARMOR_CHEST, ARMOR_HEAD, WEAPON, DIGGER, FISHING_ROD, TRIDENT, BREAKABLE, BOW, WEARABLE, CROSSBOW, VANISHABLE};
    }

    static {
        o = EnchantmentSlotType.a();
    }
}

