/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.effect.AttributeModifierTemplate;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;

public class PotionUtil {
    public static final String TAG_CUSTOM_POTION_EFFECTS = "custom_potion_effects";
    public static final String TAG_CUSTOM_POTION_COLOR = "CustomPotionColor";
    public static final String TAG_POTION = "Potion";
    private static final int EMPTY_COLOR = 0xF800F8;
    private static final IChatBaseComponent NO_EFFECT = IChatBaseComponent.translatable("effect.none").withStyle(EnumChatFormat.GRAY);

    public static List<MobEffect> getMobEffects(ItemStack var0) {
        return PotionUtil.getAllEffects(var0.getTag());
    }

    public static List<MobEffect> getAllEffects(PotionRegistry var0, Collection<MobEffect> var1) {
        ArrayList var2 = Lists.newArrayList();
        var2.addAll(var0.getEffects());
        var2.addAll(var1);
        return var2;
    }

    public static List<MobEffect> getAllEffects(@Nullable NBTTagCompound var0) {
        ArrayList var1 = Lists.newArrayList();
        var1.addAll(PotionUtil.getPotion(var0).getEffects());
        PotionUtil.getCustomEffects(var0, var1);
        return var1;
    }

    public static List<MobEffect> getCustomEffects(ItemStack var0) {
        return PotionUtil.getCustomEffects(var0.getTag());
    }

    public static List<MobEffect> getCustomEffects(@Nullable NBTTagCompound var0) {
        ArrayList var1 = Lists.newArrayList();
        PotionUtil.getCustomEffects(var0, var1);
        return var1;
    }

    public static void getCustomEffects(@Nullable NBTTagCompound var0, List<MobEffect> var1) {
        if (var0 != null && var0.contains(TAG_CUSTOM_POTION_EFFECTS, 9)) {
            NBTTagList var2 = var0.getList(TAG_CUSTOM_POTION_EFFECTS, 10);
            for (int var3 = 0; var3 < var2.size(); ++var3) {
                NBTTagCompound var4 = var2.getCompound(var3);
                MobEffect var5 = MobEffect.load(var4);
                if (var5 == null) continue;
                var1.add(var5);
            }
        }
    }

    public static int getColor(ItemStack var0) {
        NBTTagCompound var1 = var0.getTag();
        if (var1 != null && var1.contains(TAG_CUSTOM_POTION_COLOR, 99)) {
            return var1.getInt(TAG_CUSTOM_POTION_COLOR);
        }
        return PotionUtil.getPotion(var0) == Potions.EMPTY ? 0xF800F8 : PotionUtil.getColor(PotionUtil.getMobEffects(var0));
    }

    public static int getColor(PotionRegistry var0) {
        return var0 == Potions.EMPTY ? 0xF800F8 : PotionUtil.getColor(var0.getEffects());
    }

    public static int getColor(Collection<MobEffect> var0) {
        int var1 = 3694022;
        if (var0.isEmpty()) {
            return 3694022;
        }
        float var2 = 0.0f;
        float var3 = 0.0f;
        float var4 = 0.0f;
        int var5 = 0;
        for (MobEffect var7 : var0) {
            if (!var7.isVisible()) continue;
            int var8 = var7.getEffect().getColor();
            int var9 = var7.getAmplifier() + 1;
            var2 += (float)(var9 * (var8 >> 16 & 0xFF)) / 255.0f;
            var3 += (float)(var9 * (var8 >> 8 & 0xFF)) / 255.0f;
            var4 += (float)(var9 * (var8 >> 0 & 0xFF)) / 255.0f;
            var5 += var9;
        }
        if (var5 == 0) {
            return 0;
        }
        var2 = var2 / (float)var5 * 255.0f;
        var3 = var3 / (float)var5 * 255.0f;
        var4 = var4 / (float)var5 * 255.0f;
        return (int)var2 << 16 | (int)var3 << 8 | (int)var4;
    }

    public static PotionRegistry getPotion(ItemStack var0) {
        return PotionUtil.getPotion(var0.getTag());
    }

    public static PotionRegistry getPotion(@Nullable NBTTagCompound var0) {
        if (var0 == null) {
            return Potions.EMPTY;
        }
        return PotionRegistry.byName(var0.getString(TAG_POTION));
    }

    public static ItemStack setPotion(ItemStack var0, PotionRegistry var1) {
        MinecraftKey var2 = BuiltInRegistries.POTION.getKey(var1);
        if (var1 == Potions.EMPTY) {
            var0.removeTagKey(TAG_POTION);
        } else {
            var0.getOrCreateTag().putString(TAG_POTION, var2.toString());
        }
        return var0;
    }

    public static ItemStack setCustomEffects(ItemStack var0, Collection<MobEffect> var1) {
        if (var1.isEmpty()) {
            return var0;
        }
        NBTTagCompound var2 = var0.getOrCreateTag();
        NBTTagList var3 = var2.getList(TAG_CUSTOM_POTION_EFFECTS, 9);
        for (MobEffect var5 : var1) {
            var3.add(var5.save(new NBTTagCompound()));
        }
        var2.put(TAG_CUSTOM_POTION_EFFECTS, var3);
        return var0;
    }

    public static void addPotionTooltip(ItemStack var0, List<IChatBaseComponent> var1, float var2, float var3) {
        PotionUtil.addPotionTooltip(PotionUtil.getMobEffects(var0), var1, var2, var3);
    }

    public static void addPotionTooltip(List<MobEffect> var0, List<IChatBaseComponent> var1, float var2, float var3) {
        Object var7;
        ArrayList var4 = Lists.newArrayList();
        if (var0.isEmpty()) {
            var1.add(NO_EFFECT);
        } else {
            for (MobEffect var6 : var0) {
                var7 = IChatBaseComponent.translatable(var6.getDescriptionId());
                MobEffectList var8 = var6.getEffect();
                Map<AttributeBase, AttributeModifierTemplate> var9 = var8.getAttributeModifiers();
                if (!var9.isEmpty()) {
                    for (Map.Entry<AttributeBase, AttributeModifierTemplate> var11 : var9.entrySet()) {
                        var4.add(new Pair((Object)var11.getKey(), (Object)var11.getValue().create(var6.getAmplifier())));
                    }
                }
                if (var6.getAmplifier() > 0) {
                    var7 = IChatBaseComponent.translatable("potion.withAmplifier", var7, IChatBaseComponent.translatable("potion.potency." + var6.getAmplifier()));
                }
                if (!var6.endsWithin(20)) {
                    var7 = IChatBaseComponent.translatable("potion.withDuration", var7, MobEffectUtil.formatDuration(var6, var2, var3));
                }
                var1.add(((IChatMutableComponent)var7).withStyle(var8.getCategory().getTooltipFormatting()));
            }
        }
        if (!var4.isEmpty()) {
            var1.add(CommonComponents.EMPTY);
            var1.add(IChatBaseComponent.translatable("potion.whenDrank").withStyle(EnumChatFormat.DARK_PURPLE));
            for (MobEffect var6 : var4) {
                var7 = (AttributeModifier)var6.getSecond();
                double var8 = ((AttributeModifier)var7).getAmount();
                double var10 = ((AttributeModifier)var7).getOperation() == AttributeModifier.Operation.MULTIPLY_BASE || ((AttributeModifier)var7).getOperation() == AttributeModifier.Operation.MULTIPLY_TOTAL ? ((AttributeModifier)var7).getAmount() * 100.0 : ((AttributeModifier)var7).getAmount();
                if (var8 > 0.0) {
                    var1.add(IChatBaseComponent.translatable("attribute.modifier.plus." + ((AttributeModifier)var7).getOperation().toValue(), ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(var10), IChatBaseComponent.translatable(((AttributeBase)var6.getFirst()).getDescriptionId())).withStyle(EnumChatFormat.BLUE));
                    continue;
                }
                if (!(var8 < 0.0)) continue;
                var1.add(IChatBaseComponent.translatable("attribute.modifier.take." + ((AttributeModifier)var7).getOperation().toValue(), ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(var10 *= -1.0), IChatBaseComponent.translatable(((AttributeBase)var6.getFirst()).getDescriptionId())).withStyle(EnumChatFormat.RED));
            }
        }
    }
}

