/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemToolMaterial;
import net.minecraft.world.item.ItemVanishable;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class ItemTool
extends ItemToolMaterial
implements ItemVanishable {
    private final TagKey<Block> blocks;
    protected final float speed;
    private final float attackDamageBaseline;
    private final Multimap<AttributeBase, AttributeModifier> defaultModifiers;

    protected ItemTool(float var0, float var1, ToolMaterial var2, TagKey<Block> var3, Item.Info var4) {
        super(var2, var4);
        this.blocks = var3;
        this.speed = var2.getSpeed();
        this.attackDamageBaseline = var0 + var2.getAttackDamageBonus();
        ImmutableMultimap.Builder var5 = ImmutableMultimap.builder();
        var5.put((Object)GenericAttributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Tool modifier", this.attackDamageBaseline, AttributeModifier.Operation.ADDITION));
        var5.put((Object)GenericAttributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Tool modifier", var1, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = var5.build();
    }

    @Override
    public float getDestroySpeed(ItemStack var0, IBlockData var1) {
        return var1.is(this.blocks) ? this.speed : 1.0f;
    }

    @Override
    public boolean hurtEnemy(ItemStack var02, EntityLiving var1, EntityLiving var2) {
        var02.hurtAndBreak(2, var2, var0 -> var0.broadcastBreakEvent(EnumItemSlot.MAINHAND));
        return true;
    }

    @Override
    public boolean mineBlock(ItemStack var02, World var1, IBlockData var2, BlockPosition var3, EntityLiving var4) {
        if (!var1.isClientSide && var2.getDestroySpeed(var1, var3) != 0.0f) {
            var02.hurtAndBreak(1, var4, var0 -> var0.broadcastBreakEvent(EnumItemSlot.MAINHAND));
        }
        return true;
    }

    @Override
    public Multimap<AttributeBase, AttributeModifier> getDefaultAttributeModifiers(EnumItemSlot var0) {
        if (var0 == EnumItemSlot.MAINHAND) {
            return this.defaultModifiers;
        }
        return super.getDefaultAttributeModifiers(var0);
    }

    public float getAttackDamage() {
        return this.attackDamageBaseline;
    }

    @Override
    public boolean isCorrectToolForDrops(IBlockData var0) {
        int var1 = this.getTier().getLevel();
        if (var1 < 3 && var0.is(TagsBlock.NEEDS_DIAMOND_TOOL)) {
            return false;
        }
        if (var1 < 2 && var0.is(TagsBlock.NEEDS_IRON_TOOL)) {
            return false;
        }
        if (var1 < 1 && var0.is(TagsBlock.NEEDS_STONE_TOOL)) {
            return false;
        }
        return var0.is(this.blocks);
    }
}

