/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemVanishable;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemFishingRod
extends Item
implements ItemVanishable {
    public ItemFishingRod(Item.Info var0) {
        super(var0);
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var12, EnumHand var2) {
        ItemStack var3 = var12.getItemInHand(var2);
        if (var12.fishing != null) {
            if (!var0.isClientSide) {
                int var4 = var12.fishing.retrieve(var3);
                var3.hurtAndBreak(var4, var12, var1 -> var1.broadcastBreakEvent(var2));
            }
            var0.playSound(null, var12.getX(), var12.getY(), var12.getZ(), SoundEffects.FISHING_BOBBER_RETRIEVE, SoundCategory.NEUTRAL, 1.0f, 0.4f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
            var12.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
        } else {
            var0.playSound(null, var12.getX(), var12.getY(), var12.getZ(), SoundEffects.FISHING_BOBBER_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
            if (!var0.isClientSide) {
                int var4 = EnchantmentManager.getFishingSpeedBonus(var3);
                int var5 = EnchantmentManager.getFishingLuckBonus(var3);
                var0.addFreshEntity(new EntityFishingHook(var12, var0, var5, var4));
            }
            var12.awardStat(StatisticList.ITEM_USED.get(this));
            var12.gameEvent(GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }
}

