/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.function.Predicate;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemVanishable;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;

public class ItemBow
extends ItemProjectileWeapon
implements ItemVanishable {
    public static final int MAX_DRAW_DURATION = 20;
    public static final int DEFAULT_RANGE = 15;

    public ItemBow(Item.Info var0) {
        super(var0);
    }

    @Override
    public void releaseUsing(ItemStack var0, World var12, EntityLiving var2, int var3) {
        boolean var9;
        int var7;
        float var8;
        if (!(var2 instanceof EntityHuman)) {
            return;
        }
        EntityHuman var4 = (EntityHuman)var2;
        boolean var5 = var4.getAbilities().instabuild || EnchantmentManager.getItemEnchantmentLevel(Enchantments.INFINITY_ARROWS, var0) > 0;
        ItemStack var6 = var4.getProjectile(var0);
        if (var6.isEmpty() && !var5) {
            return;
        }
        if (var6.isEmpty()) {
            var6 = new ItemStack(Items.ARROW);
        }
        if ((double)(var8 = ItemBow.getPowerForTime(var7 = this.getUseDuration(var0) - var3)) < 0.1) {
            return;
        }
        boolean bl = var9 = var5 && var6.is(Items.ARROW);
        if (!var12.isClientSide) {
            int var13;
            int var122;
            ItemArrow var10 = (ItemArrow)(var6.getItem() instanceof ItemArrow ? var6.getItem() : Items.ARROW);
            EntityArrow var11 = var10.createArrow(var12, var6, var4);
            var11.shootFromRotation(var4, var4.getXRot(), var4.getYRot(), 0.0f, var8 * 3.0f, 1.0f);
            if (var8 == 1.0f) {
                var11.setCritArrow(true);
            }
            if ((var122 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.POWER_ARROWS, var0)) > 0) {
                var11.setBaseDamage(var11.getBaseDamage() + (double)var122 * 0.5 + 0.5);
            }
            if ((var13 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.PUNCH_ARROWS, var0)) > 0) {
                var11.setKnockback(var13);
            }
            if (EnchantmentManager.getItemEnchantmentLevel(Enchantments.FLAMING_ARROWS, var0) > 0) {
                var11.setSecondsOnFire(100);
            }
            var0.hurtAndBreak(1, var4, var1 -> var1.broadcastBreakEvent(var4.getUsedItemHand()));
            if (var9 || var4.getAbilities().instabuild && (var6.is(Items.SPECTRAL_ARROW) || var6.is(Items.TIPPED_ARROW))) {
                var11.pickup = EntityArrow.PickupStatus.CREATIVE_ONLY;
            }
            var12.addFreshEntity(var11);
        }
        var12.playSound(null, var4.getX(), var4.getY(), var4.getZ(), SoundEffects.ARROW_SHOOT, SoundCategory.PLAYERS, 1.0f, 1.0f / (var12.getRandom().nextFloat() * 0.4f + 1.2f) + var8 * 0.5f);
        if (!var9 && !var4.getAbilities().instabuild) {
            var6.shrink(1);
            if (var6.isEmpty()) {
                var4.getInventory().removeItem(var6);
            }
        }
        var4.awardStat(StatisticList.ITEM_USED.get(this));
    }

    public static float getPowerForTime(int var0) {
        float var1 = (float)var0 / 20.0f;
        if ((var1 = (var1 * var1 + var1 * 2.0f) / 3.0f) > 1.0f) {
            var1 = 1.0f;
        }
        return var1;
    }

    @Override
    public int getUseDuration(ItemStack var0) {
        return 72000;
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.BOW;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        boolean var4;
        ItemStack var3 = var1.getItemInHand(var2);
        boolean bl = var4 = !var1.getProjectile(var3).isEmpty();
        if (var1.getAbilities().instabuild || var4) {
            var1.startUsingItem(var2);
            return InteractionResultWrapper.consume(var3);
        }
        return InteractionResultWrapper.fail(var3);
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    @Override
    public int getDefaultProjectileRange() {
        return 15;
    }
}

