/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private static final DataWatcherObject<Integer> DATA_UNHAPPY_COUNTER = DataWatcher.defineId(EntityVillagerAbstract.class, DataWatcherRegistry.INT);
    public static final int VILLAGER_SLOT_OFFSET = 300;
    private static final int VILLAGER_INVENTORY_SIZE = 8;
    @Nullable
    private EntityHuman tradingPlayer;
    @Nullable
    protected MerchantRecipeList offers;
    private final InventorySubcontainer inventory = new InventorySubcontainer(8);

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> var0, World var1) {
        super((EntityTypes<? extends EntityAgeable>)var0, var1);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        if (var3 == null) {
            var3 = new EntityAgeable.a(false);
        }
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    public int getUnhappyCounter() {
        return this.entityData.get(DATA_UNHAPPY_COUNTER);
    }

    public void setUnhappyCounter(int var0) {
        this.entityData.set(DATA_UNHAPPY_COUNTER, var0);
    }

    @Override
    public int getVillagerXp() {
        return 0;
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        if (this.isBaby()) {
            return 0.81f;
        }
        return 1.62f;
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_UNHAPPY_COUNTER, 0);
    }

    @Override
    public void setTradingPlayer(@Nullable EntityHuman var0) {
        this.tradingPlayer = var0;
    }

    @Override
    @Nullable
    public EntityHuman getTradingPlayer() {
        return this.tradingPlayer;
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    @Override
    public MerchantRecipeList getOffers() {
        if (this.offers == null) {
            this.offers = new MerchantRecipeList();
            this.updateTrades();
        }
        return this.offers;
    }

    @Override
    public void overrideOffers(@Nullable MerchantRecipeList var0) {
    }

    @Override
    public void overrideXp(int var0) {
    }

    @Override
    public void notifyTrade(MerchantRecipe var0) {
        var0.increaseUses();
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        this.rewardTradeXp(var0);
        if (this.tradingPlayer instanceof EntityPlayer) {
            CriterionTriggers.TRADE.trigger((EntityPlayer)this.tradingPlayer, this, var0.getResult());
        }
    }

    protected abstract void rewardTradeXp(MerchantRecipe var1);

    @Override
    public boolean showProgressBar() {
        return true;
    }

    @Override
    public void notifyTradeUpdated(ItemStack var0) {
        if (!this.level().isClientSide && this.ambientSoundTime > -this.getAmbientSoundInterval() + 20) {
            this.ambientSoundTime = -this.getAmbientSoundInterval();
            this.playSound(this.getTradeUpdatedSound(!var0.isEmpty()), this.getSoundVolume(), this.getVoicePitch());
        }
    }

    @Override
    public SoundEffect getNotifyTradeSound() {
        return SoundEffects.VILLAGER_YES;
    }

    protected SoundEffect getTradeUpdatedSound(boolean var0) {
        return var0 ? SoundEffects.VILLAGER_YES : SoundEffects.VILLAGER_NO;
    }

    public void playCelebrateSound() {
        this.playSound(SoundEffects.VILLAGER_CELEBRATE, this.getSoundVolume(), this.getVoicePitch());
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        MerchantRecipeList var1 = this.getOffers();
        if (!var1.isEmpty()) {
            var0.put("Offers", var1.createTag());
        }
        this.writeInventoryToTag(var0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("Offers", 10)) {
            this.offers = new MerchantRecipeList(var0.getCompound("Offers"));
        }
        this.readInventoryFromTag(var0);
    }

    @Override
    @Nullable
    public Entity changeDimension(WorldServer var0) {
        this.stopTrading();
        return super.changeDimension(var0);
    }

    protected void stopTrading() {
        this.setTradingPlayer(null);
    }

    @Override
    public void die(DamageSource var0) {
        super.die(var0);
        this.stopTrading();
    }

    protected void addParticlesAroundSelf(ParticleParam var0) {
        for (int var1 = 0; var1 < 5; ++var1) {
            double var2 = this.random.nextGaussian() * 0.02;
            double var4 = this.random.nextGaussian() * 0.02;
            double var6 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(var0, this.getRandomX(1.0), this.getRandomY() + 1.0, this.getRandomZ(1.0), var2, var4, var6);
        }
    }

    @Override
    public boolean canBeLeashed(EntityHuman var0) {
        return false;
    }

    @Override
    public InventorySubcontainer getInventory() {
        return this.inventory;
    }

    @Override
    public SlotAccess getSlot(int var0) {
        int var1 = var0 - 300;
        if (var1 >= 0 && var1 < this.inventory.getContainerSize()) {
            return SlotAccess.forContainer(this.inventory, var1);
        }
        return super.getSlot(var0);
    }

    protected abstract void updateTrades();

    protected void addOffersFromItemListings(MerchantRecipeList var0, VillagerTrades.IMerchantRecipeOption[] var1, int var2) {
        ArrayList var3 = Lists.newArrayList((Object[])var1);
        int var4 = 0;
        while (var4 < var2 && !var3.isEmpty()) {
            MerchantRecipe var5 = ((VillagerTrades.IMerchantRecipeOption)var3.remove(this.random.nextInt(var3.size()))).getOffer(this, this.random);
            if (var5 == null) continue;
            var0.add(var5);
            ++var4;
        }
    }

    @Override
    public Vec3D getRopeHoldPosition(float var0) {
        float var1 = MathHelper.lerp(var0, this.yBodyRotO, this.yBodyRot) * ((float)Math.PI / 180);
        Vec3D var2 = new Vec3D(0.0, this.getBoundingBox().getYsize() - 1.0, 0.2);
        return this.getPosition(var0).add(var2.yRot(-var1));
    }

    @Override
    public boolean isClientSide() {
        return this.level().isClientSide;
    }
}

