/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class LongJump
extends Behavior<Breeze> {
    private static final int REQUIRED_AIR_BLOCKS_ABOVE = 4;
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 50.0;
    private static final int JUMP_COOLDOWN_TICKS = 10;
    private static final int JUMP_COOLDOWN_WHEN_HURT_TICKS = 2;
    private static final int INHALING_DURATION_TICKS = Math.round(10.0f);
    private static final float MAX_JUMP_VELOCITY = 1.4f;
    private static final ObjectArrayList<Integer> ALLOWED_ANGLES = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 55, 60, 75, 80}));

    @VisibleForTesting
    public LongJump() {
        super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_PRESENT, MemoryModuleType.BREEZE_JUMP_COOLDOWN, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_JUMP_INHALING, MemoryStatus.REGISTERED, MemoryModuleType.BREEZE_JUMP_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.BREEZE_SHOOT, MemoryStatus.VALUE_ABSENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT), 200);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, Breeze var1) {
        if (!var1.onGround() && !var1.isInWater()) {
            return false;
        }
        if (var1.getBrain().checkMemory(MemoryModuleType.BREEZE_JUMP_TARGET, MemoryStatus.VALUE_PRESENT)) {
            return true;
        }
        EntityLiving var2 = var1.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (var2 == null) {
            return false;
        }
        if (LongJump.outOfAggroRange(var1, var2)) {
            var1.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            return false;
        }
        if (LongJump.tooCloseForJump(var1, var2)) {
            return false;
        }
        if (!LongJump.canJumpFromCurrentPosition(var0, var1)) {
            return false;
        }
        BlockPosition var3 = LongJump.snapToSurface(var1, LongJump.randomPointBehindTarget(var2, var1.getRandom()));
        if (var3 == null) {
            return false;
        }
        if (!LongJump.hasLineOfSight(var1, var3.getCenter()) && !LongJump.hasLineOfSight(var1, var3.above(4).getCenter())) {
            return false;
        }
        var1.getBrain().setMemory(MemoryModuleType.BREEZE_JUMP_TARGET, var3);
        return true;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, Breeze var1, long var2) {
        return var1.getPose() != EntityPose.STANDING && !var1.getBrain().hasMemoryValue(MemoryModuleType.BREEZE_JUMP_COOLDOWN);
    }

    @Override
    protected void start(WorldServer var0, Breeze var12, long var2) {
        if (var12.getBrain().checkMemory(MemoryModuleType.BREEZE_JUMP_INHALING, MemoryStatus.VALUE_ABSENT)) {
            var12.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_JUMP_INHALING, Unit.INSTANCE, INHALING_DURATION_TICKS);
        }
        var12.setPose(EntityPose.INHALING);
        var12.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_TARGET).ifPresent(var1 -> var12.lookAt(ArgumentAnchor.Anchor.EYES, var1.getCenter()));
    }

    @Override
    protected void tick(WorldServer var0, Breeze var12, long var2) {
        if (LongJump.finishedInhaling(var12)) {
            Vec3D var4 = var12.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_TARGET).flatMap(var1 -> LongJump.calculateOptimalJumpVector(var12, var12.getRandom(), Vec3D.atBottomCenterOf(var1))).orElse(null);
            if (var4 == null) {
                var12.setPose(EntityPose.STANDING);
                return;
            }
            var12.playSound(SoundEffects.BREEZE_JUMP, 1.0f, 1.0f);
            var12.setPose(EntityPose.LONG_JUMPING);
            var12.setYRot(var12.yBodyRot);
            var12.setDiscardFriction(true);
            var12.setDeltaMovement(var4);
        } else if (LongJump.finishedJumping(var12)) {
            var12.playSound(SoundEffects.BREEZE_LAND, 1.0f, 1.0f);
            var12.setPose(EntityPose.STANDING);
            var12.setDiscardFriction(false);
            boolean var4 = var12.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
            var12.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_JUMP_COOLDOWN, Unit.INSTANCE, var4 ? 2L : 10L);
            var12.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT, Unit.INSTANCE, 100L);
        }
    }

    @Override
    protected void stop(WorldServer var0, Breeze var1, long var2) {
        if (var1.getPose() == EntityPose.LONG_JUMPING || var1.getPose() == EntityPose.INHALING) {
            var1.setPose(EntityPose.STANDING);
        }
        var1.getBrain().eraseMemory(MemoryModuleType.BREEZE_JUMP_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.BREEZE_JUMP_INHALING);
    }

    private static boolean finishedInhaling(Breeze var0) {
        return var0.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_INHALING).isEmpty() && var0.getPose() == EntityPose.INHALING;
    }

    private static boolean finishedJumping(Breeze var0) {
        return var0.getPose() == EntityPose.LONG_JUMPING && var0.onGround();
    }

    private static Vec3D randomPointBehindTarget(EntityLiving var0, RandomSource var1) {
        int var2 = 90;
        float var3 = var0.yHeadRot + 180.0f + (float)var1.nextGaussian() * 90.0f / 2.0f;
        float var4 = MathHelper.lerp(var1.nextFloat(), 4.0f, 8.0f);
        Vec3D var5 = Vec3D.directionFromRotation(0.0f, var3).scale(var4);
        return var0.position().add(var5);
    }

    @Nullable
    private static BlockPosition snapToSurface(EntityLiving var0, Vec3D var1) {
        RayTrace var2 = new RayTrace(var1, var1.relative(EnumDirection.DOWN, 10.0), RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, var0);
        MovingObjectPositionBlock var3 = var0.level().clip(var2);
        if (((MovingObjectPosition)var3).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            return BlockPosition.containing(var3.getLocation()).above();
        }
        RayTrace var4 = new RayTrace(var1, var1.relative(EnumDirection.UP, 10.0), RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, var0);
        MovingObjectPositionBlock var5 = var0.level().clip(var4);
        if (((MovingObjectPosition)var5).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            return BlockPosition.containing(var3.getLocation()).above();
        }
        return null;
    }

    @VisibleForTesting
    public static boolean hasLineOfSight(Breeze var0, Vec3D var1) {
        Vec3D var2 = new Vec3D(var0.getX(), var0.getY(), var0.getZ());
        if (var1.distanceTo(var2) > 50.0) {
            return false;
        }
        return var0.level().clip(new RayTrace(var2, var1, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, var0)).getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    private static boolean outOfAggroRange(Breeze var0, EntityLiving var1) {
        return !var1.closerThan(var0, 24.0);
    }

    private static boolean tooCloseForJump(Breeze var0, EntityLiving var1) {
        return var1.distanceTo(var0) - 4.0f <= 0.0f;
    }

    private static boolean canJumpFromCurrentPosition(WorldServer var0, Breeze var1) {
        BlockPosition var2 = var1.blockPosition();
        for (int var3 = 1; var3 <= 4; ++var3) {
            BlockPosition var4 = var2.relative(EnumDirection.UP, var3);
            if (var0.getBlockState(var4).isAir() || var0.getFluidState(var4).is(TagsFluid.WATER)) continue;
            return false;
        }
        return true;
    }

    private static Optional<Vec3D> calculateOptimalJumpVector(Breeze var0, RandomSource var1, Vec3D var2) {
        List<Integer> var3 = SystemUtils.shuffledCopy(ALLOWED_ANGLES, var1);
        for (int var5 : var3) {
            Optional<Vec3D> var6 = LongJumpUtil.calculateJumpVectorForAngle(var0, var2, 1.4f, var5, false);
            if (!var6.isPresent()) continue;
            return var6;
        }
        return Optional.empty();
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (Breeze)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (Breeze)entityLiving, l2);
    }
}

