/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;

public class EntitySkeletonWither
extends EntitySkeletonAbstract {
    public EntitySkeletonWither(EntityTypes<? extends EntitySkeletonWither> var0, World var1) {
        super((EntityTypes<? extends EntitySkeletonAbstract>)var0, var1);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
    }

    @Override
    protected void registerGoals() {
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityPiglinAbstract>((EntityInsentient)this, EntityPiglinAbstract.class, true));
        super.registerGoals();
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.WITHER_SKELETON_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.WITHER_SKELETON_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.WITHER_SKELETON_DEATH;
    }

    @Override
    SoundEffect getStepSound() {
        return SoundEffects.WITHER_SKELETON_STEP;
    }

    @Override
    protected void dropCustomDeathLoot(DamageSource var0, int var1, boolean var2) {
        EntityCreeper var4;
        super.dropCustomDeathLoot(var0, var1, var2);
        Entity var3 = var0.getEntity();
        if (var3 instanceof EntityCreeper && (var4 = (EntityCreeper)var3).canDropMobsSkull()) {
            var4.increaseDroppedSkulls();
            this.spawnAtLocation(Items.WITHER_SKELETON_SKULL);
        }
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.STONE_SWORD));
    }

    @Override
    protected void populateDefaultEquipmentEnchantments(RandomSource var0, DifficultyDamageScaler var1) {
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        GroupDataEntity var5 = super.finalizeSpawn(var0, var1, var2, var3, var4);
        this.getAttribute(GenericAttributes.ATTACK_DAMAGE).setBaseValue(4.0);
        this.reassessWeaponGoal();
        return var5;
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return 2.1f;
    }

    @Override
    protected float ridingOffset(Entity var0) {
        return -0.875f;
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        if (!super.doHurtTarget(var0)) {
            return false;
        }
        if (var0 instanceof EntityLiving) {
            ((EntityLiving)var0).addEffect(new MobEffect(MobEffects.WITHER, 200), this);
        }
        return true;
    }

    @Override
    protected EntityArrow getArrow(ItemStack var0, float var1) {
        EntityArrow var2 = super.getArrow(var0, var1);
        var2.setSecondsOnFire(100);
        return var2;
    }

    @Override
    public boolean canBeAffected(MobEffect var0) {
        if (var0.getEffect() == MobEffects.WITHER) {
            return false;
        }
        return super.canBeAffected(var0);
    }
}

