/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorGate<E extends EntityLiving>
implements BehaviorControl<E> {
    private final Map<MemoryModuleType<?>, MemoryStatus> entryCondition;
    private final Set<MemoryModuleType<?>> exitErasedMemories;
    private final Order orderPolicy;
    private final Execution runningPolicy;
    private final ShufflingList<BehaviorControl<? super E>> behaviors = new ShufflingList();
    private Behavior.Status status = Behavior.Status.STOPPED;

    public BehaviorGate(Map<MemoryModuleType<?>, MemoryStatus> var02, Set<MemoryModuleType<?>> var1, Order var2, Execution var3, List<Pair<? extends BehaviorControl<? super E>, Integer>> var4) {
        this.entryCondition = var02;
        this.exitErasedMemories = var1;
        this.orderPolicy = var2;
        this.runningPolicy = var3;
        var4.forEach(var0 -> this.behaviors.add((BehaviorControl)var0.getFirst(), (Integer)var0.getSecond()));
    }

    @Override
    public Behavior.Status getStatus() {
        return this.status;
    }

    private boolean hasRequiredMemories(E var0) {
        for (Map.Entry<MemoryModuleType<?>, MemoryStatus> var2 : this.entryCondition.entrySet()) {
            MemoryModuleType<?> var3 = var2.getKey();
            MemoryStatus var4 = var2.getValue();
            if (((EntityLiving)var0).getBrain().checkMemory(var3, var4)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean tryStart(WorldServer var0, E var1, long var2) {
        if (this.hasRequiredMemories(var1)) {
            this.status = Behavior.Status.RUNNING;
            this.orderPolicy.apply(this.behaviors);
            this.runningPolicy.apply(this.behaviors.stream(), var0, var1, var2);
            return true;
        }
        return false;
    }

    @Override
    public final void tickOrStop(WorldServer var02, E var1, long var2) {
        this.behaviors.stream().filter(var0 -> var0.getStatus() == Behavior.Status.RUNNING).forEach(var4 -> var4.tickOrStop(var02, var1, var2));
        if (this.behaviors.stream().noneMatch(var0 -> var0.getStatus() == Behavior.Status.RUNNING)) {
            this.doStop(var02, var1, var2);
        }
    }

    @Override
    public final void doStop(WorldServer var02, E var1, long var2) {
        this.status = Behavior.Status.STOPPED;
        this.behaviors.stream().filter(var0 -> var0.getStatus() == Behavior.Status.RUNNING).forEach(var4 -> var4.doStop(var02, var1, var2));
        this.exitErasedMemories.forEach(((EntityLiving)var1).getBrain()::eraseMemory);
    }

    @Override
    public String debugString() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        Set var02 = this.behaviors.stream().filter(var0 -> var0.getStatus() == Behavior.Status.RUNNING).collect(Collectors.toSet());
        return "(" + this.getClass().getSimpleName() + "): " + var02;
    }

    public static final class Order
    extends Enum<Order> {
        public static final /* enum */ Order ORDERED = new Order(var0 -> {});
        public static final /* enum */ Order SHUFFLED = new Order(ShufflingList::shuffle);
        private final Consumer<ShufflingList<?>> consumer;
        private static final /* synthetic */ Order[] d;

        public static Order[] values() {
            return (Order[])d.clone();
        }

        public static Order valueOf(String var0) {
            return Enum.valueOf(Order.class, var0);
        }

        private Order(Consumer var2) {
            this.consumer = var2;
        }

        public void apply(ShufflingList<?> var0) {
            this.consumer.accept(var0);
        }

        private static /* synthetic */ Order[] a() {
            return new Order[]{ORDERED, SHUFFLED};
        }

        static {
            d = Order.a();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Execution
    extends Enum<Execution> {
        public static final /* enum */ Execution RUN_ONE = new Execution(){

            @Override
            public <E extends EntityLiving> void apply(Stream<BehaviorControl<? super E>> var02, WorldServer var1, E var2, long var3) {
                var02.filter(var0 -> var0.getStatus() == Behavior.Status.STOPPED).filter(var4 -> var4.tryStart(var1, var2, var3)).findFirst();
            }
        };
        public static final /* enum */ Execution TRY_ALL = new Execution(){

            @Override
            public <E extends EntityLiving> void apply(Stream<BehaviorControl<? super E>> var02, WorldServer var1, E var2, long var3) {
                var02.filter(var0 -> var0.getStatus() == Behavior.Status.STOPPED).forEach(var4 -> var4.tryStart(var1, var2, var3));
            }
        };
        private static final /* synthetic */ Execution[] c;

        public static Execution[] values() {
            return (Execution[])c.clone();
        }

        public static Execution valueOf(String var0) {
            return Enum.valueOf(Execution.class, var0);
        }

        public abstract <E extends EntityLiving> void apply(Stream<BehaviorControl<? super E>> var1, WorldServer var2, E var3, long var4);

        private static /* synthetic */ Execution[] a() {
            return new Execution[]{RUN_ONE, TRY_ALL};
        }

        static {
            c = Execution.a();
        }
    }
}

