/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.HeightMap;

public class EntityPositionTypes {
    private static final Map<EntityTypes<?>, a> DATA_BY_TYPE = Maps.newHashMap();

    private static <T extends EntityInsentient> void register(EntityTypes<T> var0, Surface var1, HeightMap.Type var2, b<T> var3) {
        a var4 = DATA_BY_TYPE.put(var0, new a(var2, var1, var3));
        if (var4 != null) {
            throw new IllegalStateException("Duplicate registration for type " + BuiltInRegistries.ENTITY_TYPE.getKey(var0));
        }
    }

    public static Surface getPlacementType(EntityTypes<?> var0) {
        a var1 = DATA_BY_TYPE.get(var0);
        return var1 == null ? Surface.NO_RESTRICTIONS : var1.placement;
    }

    public static HeightMap.Type getHeightmapType(@Nullable EntityTypes<?> var0) {
        a var1 = DATA_BY_TYPE.get(var0);
        return var1 == null ? HeightMap.Type.MOTION_BLOCKING_NO_LEAVES : var1.heightMap;
    }

    public static <T extends Entity> boolean checkSpawnRules(EntityTypes<T> var0, WorldAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        a var5 = DATA_BY_TYPE.get(var0);
        return var5 == null || var5.predicate.test(var0, var1, var2, var3, var4);
    }

    static {
        EntityPositionTypes.register(EntityTypes.AXOLOTL, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, Axolotl::checkAxolotlSpawnRules);
        EntityPositionTypes.register(EntityTypes.COD, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWaterAnimal::checkSurfaceWaterAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.DOLPHIN, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWaterAnimal::checkSurfaceWaterAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.DROWNED, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityDrowned::checkDrownedSpawnRules);
        EntityPositionTypes.register(EntityTypes.GUARDIAN, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityGuardian::checkGuardianSpawnRules);
        EntityPositionTypes.register(EntityTypes.PUFFERFISH, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWaterAnimal::checkSurfaceWaterAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.SALMON, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWaterAnimal::checkSurfaceWaterAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.SQUID, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWaterAnimal::checkSurfaceWaterAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.TROPICAL_FISH, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityTropicalFish::checkTropicalFishSpawnRules);
        EntityPositionTypes.register(EntityTypes.BAT, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityBat::checkBatSpawnRules);
        EntityPositionTypes.register(EntityTypes.BLAZE, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkAnyLightMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.CAVE_SPIDER, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.CHICKEN, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.COW, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.CREEPER, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.DONKEY, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.ENDERMAN, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.ENDERMITE, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityEndermite::checkEndermiteSpawnRules);
        EntityPositionTypes.register(EntityTypes.ENDER_DRAGON, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.FROG, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, Frog::checkFrogSpawnRules);
        EntityPositionTypes.register(EntityTypes.GHAST, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityGhast::checkGhastSpawnRules);
        EntityPositionTypes.register(EntityTypes.GIANT, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.GLOW_SQUID, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, GlowSquid::checkGlowSquidSpawnRules);
        EntityPositionTypes.register(EntityTypes.GOAT, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, Goat::checkGoatSpawnRules);
        EntityPositionTypes.register(EntityTypes.HORSE, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.HUSK, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityZombieHusk::checkHuskSpawnRules);
        EntityPositionTypes.register(EntityTypes.IRON_GOLEM, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.LLAMA, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.MAGMA_CUBE, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMagmaCube::checkMagmaCubeSpawnRules);
        EntityPositionTypes.register(EntityTypes.MOOSHROOM, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMushroomCow::checkMushroomSpawnRules);
        EntityPositionTypes.register(EntityTypes.MULE, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.OCELOT, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING, EntityOcelot::checkOcelotSpawnRules);
        EntityPositionTypes.register(EntityTypes.PARROT, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING, EntityParrot::checkParrotSpawnRules);
        EntityPositionTypes.register(EntityTypes.PIG, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.HOGLIN, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityHoglin::checkHoglinSpawnRules);
        EntityPositionTypes.register(EntityTypes.PIGLIN, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityPiglin::checkPiglinSpawnRules);
        EntityPositionTypes.register(EntityTypes.PILLAGER, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonsterPatrolling::checkPatrollingMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.POLAR_BEAR, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityPolarBear::checkPolarBearSpawnRules);
        EntityPositionTypes.register(EntityTypes.RABBIT, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityRabbit::checkRabbitSpawnRules);
        EntityPositionTypes.register(EntityTypes.SHEEP, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.SILVERFISH, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySilverfish::checkSilverfishSpawnRules);
        EntityPositionTypes.register(EntityTypes.SKELETON, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.SKELETON_HORSE, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityHorseSkeleton::checkSkeletonHorseSpawnRules);
        EntityPositionTypes.register(EntityTypes.SLIME, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySlime::checkSlimeSpawnRules);
        EntityPositionTypes.register(EntityTypes.SNOW_GOLEM, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.SPIDER, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.STRAY, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySkeletonStray::checkStraySpawnRules);
        EntityPositionTypes.register(EntityTypes.STRIDER, Surface.IN_LAVA, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityStrider::checkStriderSpawnRules);
        EntityPositionTypes.register(EntityTypes.TURTLE, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityTurtle::checkTurtleSpawnRules);
        EntityPositionTypes.register(EntityTypes.VILLAGER, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.WITCH, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.WITHER, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.WITHER_SKELETON, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.WOLF, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWolf::checkWolfSpawnRules);
        EntityPositionTypes.register(EntityTypes.ZOMBIE, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.ZOMBIE_HORSE, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityHorseZombie::checkZombieHorseSpawnRules);
        EntityPositionTypes.register(EntityTypes.ZOMBIFIED_PIGLIN, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityPigZombie::checkZombifiedPiglinSpawnRules);
        EntityPositionTypes.register(EntityTypes.ZOMBIE_VILLAGER, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.CAT, Surface.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.ELDER_GUARDIAN, Surface.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityGuardian::checkGuardianSpawnRules);
        EntityPositionTypes.register(EntityTypes.EVOKER, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.FOX, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityFox::checkFoxSpawnRules);
        EntityPositionTypes.register(EntityTypes.ILLUSIONER, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.PANDA, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.PHANTOM, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.RAVAGER, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.SHULKER, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.TRADER_LLAMA, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.VEX, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.VINDICATOR, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.WANDERING_TRADER, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.WARDEN, Surface.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
    }

    static class a {
        final HeightMap.Type heightMap;
        final Surface placement;
        final b<?> predicate;

        public a(HeightMap.Type var0, Surface var1, b<?> var2) {
            this.heightMap = var0;
            this.placement = var1;
            this.predicate = var2;
        }
    }

    public static final class Surface
    extends Enum<Surface> {
        public static final /* enum */ Surface ON_GROUND = new Surface();
        public static final /* enum */ Surface IN_WATER = new Surface();
        public static final /* enum */ Surface NO_RESTRICTIONS = new Surface();
        public static final /* enum */ Surface IN_LAVA = new Surface();
        private static final /* synthetic */ Surface[] e;

        public static Surface[] values() {
            return (Surface[])e.clone();
        }

        public static Surface valueOf(String var0) {
            return Enum.valueOf(Surface.class, var0);
        }

        private static /* synthetic */ Surface[] a() {
            return new Surface[]{ON_GROUND, IN_WATER, NO_RESTRICTIONS, IN_LAVA};
        }

        static {
            e = Surface.a();
        }
    }

    @FunctionalInterface
    public static interface b<T extends Entity> {
        public boolean test(EntityTypes<T> var1, WorldAccess var2, EnumMobSpawn var3, BlockPosition var4, RandomSource var5);
    }
}

