/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityCreature
extends EntityInsentient {
    protected static final float DEFAULT_WALK_TARGET_VALUE = 0.0f;

    protected EntityCreature(EntityTypes<? extends EntityCreature> var0, World var1) {
        super((EntityTypes<? extends EntityInsentient>)var0, var1);
    }

    public float getWalkTargetValue(BlockPosition var0) {
        return this.getWalkTargetValue(var0, this.level());
    }

    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        return 0.0f;
    }

    @Override
    public boolean checkSpawnRules(GeneratorAccess var0, EnumMobSpawn var1) {
        return this.getWalkTargetValue(this.blockPosition(), var0) >= 0.0f;
    }

    public boolean isPathFinding() {
        return !this.getNavigation().isDone();
    }

    public boolean isPanicking() {
        if (this.brain.hasMemoryValue(MemoryModuleType.IS_PANICKING)) {
            return this.brain.getMemory(MemoryModuleType.IS_PANICKING).isPresent();
        }
        return this.goalSelector.getRunningGoals().anyMatch(var0 -> var0.getGoal() instanceof PathfinderGoalPanic);
    }

    @Override
    protected void tickLeash() {
        super.tickLeash();
        Entity var0 = this.getLeashHolder();
        if (var0 != null && var0.level() == this.level()) {
            this.restrictTo(var0.blockPosition(), 5);
            float var1 = this.distanceTo(var0);
            if (this instanceof EntityTameableAnimal && ((EntityTameableAnimal)this).isInSittingPose()) {
                if (var1 > 10.0f) {
                    this.dropLeash(true, true);
                }
                return;
            }
            this.onLeashDistance(var1);
            if (var1 > 10.0f) {
                this.dropLeash(true, true);
                this.goalSelector.disableControlFlag(PathfinderGoal.Type.MOVE);
            } else if (var1 > 6.0f) {
                double var2 = (var0.getX() - this.getX()) / (double)var1;
                double var4 = (var0.getY() - this.getY()) / (double)var1;
                double var6 = (var0.getZ() - this.getZ()) / (double)var1;
                this.setDeltaMovement(this.getDeltaMovement().add(Math.copySign(var2 * var2 * 0.4, var2), Math.copySign(var4 * var4 * 0.4, var4), Math.copySign(var6 * var6 * 0.4, var6)));
                this.checkSlowFallDistance();
            } else if (this.shouldStayCloseToLeashHolder() && !this.isPanicking()) {
                this.goalSelector.enableControlFlag(PathfinderGoal.Type.MOVE);
                float var2 = 2.0f;
                Vec3D var3 = new Vec3D(var0.getX() - this.getX(), var0.getY() - this.getY(), var0.getZ() - this.getZ()).normalize().scale(Math.max(var1 - 2.0f, 0.0f));
                this.getNavigation().moveTo(this.getX() + var3.x, this.getY() + var3.y, this.getZ() + var3.z, this.followLeashSpeed());
            }
        }
    }

    protected boolean shouldStayCloseToLeashHolder() {
        return true;
    }

    protected double followLeashSpeed() {
        return 1.0;
    }

    protected void onLeashDistance(float var0) {
    }
}

