/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.AbsorptionMobEffect;
import net.minecraft.world.effect.BadOmenMobEffect;
import net.minecraft.world.effect.HealOrHarmMobEffect;
import net.minecraft.world.effect.HungerMobEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.PoisonMobEffect;
import net.minecraft.world.effect.RegenerationMobEffect;
import net.minecraft.world.effect.SaturationMobEffect;
import net.minecraft.world.effect.WitherMobEffect;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;

public class MobEffects {
    private static final int DARKNESS_EFFECT_FACTOR_PADDING_DURATION_TICKS = 22;
    public static final MobEffectList MOVEMENT_SPEED = MobEffects.register("speed", new MobEffectList(MobEffectInfo.BENEFICIAL, 3402751).addAttributeModifier(GenericAttributes.MOVEMENT_SPEED, "91AEAA56-376B-4498-935B-2F7F68070635", 0.2f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final MobEffectList MOVEMENT_SLOWDOWN = MobEffects.register("slowness", new MobEffectList(MobEffectInfo.HARMFUL, 9154528).addAttributeModifier(GenericAttributes.MOVEMENT_SPEED, "7107DE5E-7CE8-4030-940E-514C1F160890", -0.15f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final MobEffectList DIG_SPEED = MobEffects.register("haste", new MobEffectList(MobEffectInfo.BENEFICIAL, 14270531).addAttributeModifier(GenericAttributes.ATTACK_SPEED, "AF8B6E3F-3328-4C0A-AA36-5BA2BB9DBEF3", 0.1f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final MobEffectList DIG_SLOWDOWN = MobEffects.register("mining_fatigue", new MobEffectList(MobEffectInfo.HARMFUL, 4866583).addAttributeModifier(GenericAttributes.ATTACK_SPEED, "55FCED67-E92A-486E-9800-B47F202C4386", -0.1f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final MobEffectList DAMAGE_BOOST = MobEffects.register("strength", new MobEffectList(MobEffectInfo.BENEFICIAL, 16762624).addAttributeModifier(GenericAttributes.ATTACK_DAMAGE, "648D7064-6A60-4F59-8ABE-C2C23A6DD7A9", 3.0, AttributeModifier.Operation.ADDITION));
    public static final MobEffectList HEAL = MobEffects.register("instant_health", new HealOrHarmMobEffect(MobEffectInfo.BENEFICIAL, 16262179, false));
    public static final MobEffectList HARM = MobEffects.register("instant_damage", new HealOrHarmMobEffect(MobEffectInfo.HARMFUL, 11101546, true));
    public static final MobEffectList JUMP = MobEffects.register("jump_boost", new MobEffectList(MobEffectInfo.BENEFICIAL, 16646020));
    public static final MobEffectList CONFUSION = MobEffects.register("nausea", new MobEffectList(MobEffectInfo.HARMFUL, 5578058));
    public static final MobEffectList REGENERATION = MobEffects.register("regeneration", new RegenerationMobEffect(MobEffectInfo.BENEFICIAL, 13458603));
    public static final MobEffectList DAMAGE_RESISTANCE = MobEffects.register("resistance", new MobEffectList(MobEffectInfo.BENEFICIAL, 9520880));
    public static final MobEffectList FIRE_RESISTANCE = MobEffects.register("fire_resistance", new MobEffectList(MobEffectInfo.BENEFICIAL, 0xFF9900));
    public static final MobEffectList WATER_BREATHING = MobEffects.register("water_breathing", new MobEffectList(MobEffectInfo.BENEFICIAL, 10017472));
    public static final MobEffectList INVISIBILITY = MobEffects.register("invisibility", new MobEffectList(MobEffectInfo.BENEFICIAL, 0xF6F6F6));
    public static final MobEffectList BLINDNESS = MobEffects.register("blindness", new MobEffectList(MobEffectInfo.HARMFUL, 2039587));
    public static final MobEffectList NIGHT_VISION = MobEffects.register("night_vision", new MobEffectList(MobEffectInfo.BENEFICIAL, 12779366));
    public static final MobEffectList HUNGER = MobEffects.register("hunger", new HungerMobEffect(MobEffectInfo.HARMFUL, 5797459));
    public static final MobEffectList WEAKNESS = MobEffects.register("weakness", new MobEffectList(MobEffectInfo.HARMFUL, 0x484D48).addAttributeModifier(GenericAttributes.ATTACK_DAMAGE, "22653B89-116E-49DC-9B6B-9971489B5BE5", -4.0, AttributeModifier.Operation.ADDITION));
    public static final MobEffectList POISON = MobEffects.register("poison", new PoisonMobEffect(MobEffectInfo.HARMFUL, 8889187));
    public static final MobEffectList WITHER = MobEffects.register("wither", new WitherMobEffect(MobEffectInfo.HARMFUL, 7561558));
    public static final MobEffectList HEALTH_BOOST = MobEffects.register("health_boost", new MobEffectList(MobEffectInfo.BENEFICIAL, 16284963).addAttributeModifier(GenericAttributes.MAX_HEALTH, "5D6F0BA2-1186-46AC-B896-C61C5CEE99CC", 4.0, AttributeModifier.Operation.ADDITION));
    public static final MobEffectList ABSORPTION = MobEffects.register("absorption", new AbsorptionMobEffect(MobEffectInfo.BENEFICIAL, 0x2552A5).addAttributeModifier(GenericAttributes.MAX_ABSORPTION, "EAE29CF0-701E-4ED6-883A-96F798F3DAB5", 4.0, AttributeModifier.Operation.ADDITION));
    public static final MobEffectList SATURATION = MobEffects.register("saturation", new SaturationMobEffect(MobEffectInfo.BENEFICIAL, 16262179));
    public static final MobEffectList GLOWING = MobEffects.register("glowing", new MobEffectList(MobEffectInfo.NEUTRAL, 9740385));
    public static final MobEffectList LEVITATION = MobEffects.register("levitation", new MobEffectList(MobEffectInfo.HARMFUL, 0xCEFFFF));
    public static final MobEffectList LUCK = MobEffects.register("luck", new MobEffectList(MobEffectInfo.BENEFICIAL, 5882118).addAttributeModifier(GenericAttributes.LUCK, "03C3C89D-7037-4B42-869F-B146BCB64D2E", 1.0, AttributeModifier.Operation.ADDITION));
    public static final MobEffectList UNLUCK = MobEffects.register("unluck", new MobEffectList(MobEffectInfo.HARMFUL, 12624973).addAttributeModifier(GenericAttributes.LUCK, "CC5AF142-2BD2-4215-B636-2605AED11727", -1.0, AttributeModifier.Operation.ADDITION));
    public static final MobEffectList SLOW_FALLING = MobEffects.register("slow_falling", new MobEffectList(MobEffectInfo.BENEFICIAL, 15978425));
    public static final MobEffectList CONDUIT_POWER = MobEffects.register("conduit_power", new MobEffectList(MobEffectInfo.BENEFICIAL, 1950417));
    public static final MobEffectList DOLPHINS_GRACE = MobEffects.register("dolphins_grace", new MobEffectList(MobEffectInfo.BENEFICIAL, 8954814));
    public static final MobEffectList BAD_OMEN = MobEffects.register("bad_omen", new BadOmenMobEffect(MobEffectInfo.NEUTRAL, 745784));
    public static final MobEffectList HERO_OF_THE_VILLAGE = MobEffects.register("hero_of_the_village", new MobEffectList(MobEffectInfo.BENEFICIAL, 0x44FF44));
    public static final MobEffectList DARKNESS = MobEffects.register("darkness", new MobEffectList(MobEffectInfo.HARMFUL, 2696993).setFactorDataFactory(() -> new MobEffect.a(22)));

    private static MobEffectList register(String var0, MobEffectList var1) {
        return IRegistry.register(BuiltInRegistries.MOB_EFFECT, var0, var1);
    }
}

