/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3D;

public class DamageSource {
    private final Holder<DamageType> type;
    @Nullable
    private final Entity causingEntity;
    @Nullable
    private final Entity directEntity;
    @Nullable
    private final Vec3D damageSourcePosition;

    public String toString() {
        return "DamageSource (" + this.type().msgId() + ")";
    }

    public float getFoodExhaustion() {
        return this.type().exhaustion();
    }

    public boolean isIndirect() {
        return this.causingEntity != this.directEntity;
    }

    private DamageSource(Holder<DamageType> var0, @Nullable Entity var1, @Nullable Entity var2, @Nullable Vec3D var3) {
        this.type = var0;
        this.causingEntity = var2;
        this.directEntity = var1;
        this.damageSourcePosition = var3;
    }

    public DamageSource(Holder<DamageType> var0, @Nullable Entity var1, @Nullable Entity var2) {
        this(var0, var1, var2, null);
    }

    public DamageSource(Holder<DamageType> var0, Vec3D var1) {
        this(var0, null, null, var1);
    }

    public DamageSource(Holder<DamageType> var0, @Nullable Entity var1) {
        this(var0, var1, var1);
    }

    public DamageSource(Holder<DamageType> var0) {
        this(var0, null, null, null);
    }

    @Nullable
    public Entity getDirectEntity() {
        return this.directEntity;
    }

    @Nullable
    public Entity getEntity() {
        return this.causingEntity;
    }

    public IChatBaseComponent getLocalizedDeathMessage(EntityLiving var0) {
        String var1 = "death.attack." + this.type().msgId();
        if (this.causingEntity != null || this.directEntity != null) {
            ItemStack var3;
            IChatBaseComponent var2 = this.causingEntity == null ? this.directEntity.getDisplayName() : this.causingEntity.getDisplayName();
            Entity entity = this.causingEntity;
            if (entity instanceof EntityLiving) {
                EntityLiving var4 = (EntityLiving)entity;
                v0 = var4.getMainHandItem();
            } else {
                v0 = var3 = ItemStack.EMPTY;
            }
            if (!var3.isEmpty() && var3.hasCustomHoverName()) {
                return IChatBaseComponent.translatable(var1 + ".item", var0.getDisplayName(), var2, var3.getDisplayName());
            }
            return IChatBaseComponent.translatable(var1, var0.getDisplayName(), var2);
        }
        EntityLiving var2 = var0.getKillCredit();
        String var3 = var1 + ".player";
        if (var2 != null) {
            return IChatBaseComponent.translatable(var3, var0.getDisplayName(), var2.getDisplayName());
        }
        return IChatBaseComponent.translatable(var1, var0.getDisplayName());
    }

    public String getMsgId() {
        return this.type().msgId();
    }

    public boolean scalesWithDifficulty() {
        return switch (this.type().scaling()) {
            default -> throw new IncompatibleClassChangeError();
            case DamageScaling.NEVER -> false;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> {
                if (this.causingEntity instanceof EntityLiving && !(this.causingEntity instanceof EntityHuman)) {
                    yield true;
                }
                yield false;
            }
            case DamageScaling.ALWAYS -> true;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCreativePlayer() {
        Entity entity = this.getEntity();
        if (!(entity instanceof EntityHuman)) return false;
        EntityHuman var0 = (EntityHuman)entity;
        if (!var0.getAbilities().instabuild) return false;
        return true;
    }

    @Nullable
    public Vec3D getSourcePosition() {
        if (this.damageSourcePosition != null) {
            return this.damageSourcePosition;
        }
        if (this.directEntity != null) {
            return this.directEntity.position();
        }
        return null;
    }

    @Nullable
    public Vec3D sourcePositionRaw() {
        return this.damageSourcePosition;
    }

    public boolean is(TagKey<DamageType> var0) {
        return this.type.is(var0);
    }

    public boolean is(ResourceKey<DamageType> var0) {
        return this.type.is(var0);
    }

    public DamageType type() {
        return this.type.value();
    }

    public Holder<DamageType> typeHolder() {
        return this.type;
    }
}

