/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DropInvalidSignDataFix
extends DataConverterNamedEntity {
    private static final String[] FIELDS_TO_DROP = new String[]{"Text1", "Text2", "Text3", "Text4", "FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4", "Color", "GlowingText"};

    public DropInvalidSignDataFix(Schema var0, String var1, String var2) {
        super(var0, false, var1, DataConverterTypes.BLOCK_ENTITY, var2);
    }

    private static <T> Dynamic<T> fix(Dynamic<T> var0) {
        var0 = var0.update("front_text", DropInvalidSignDataFix::fixText);
        var0 = var0.update("back_text", DropInvalidSignDataFix::fixText);
        for (String var4 : FIELDS_TO_DROP) {
            var0 = var0.remove(var4);
        }
        return var0;
    }

    private static <T> Dynamic<T> fixText(Dynamic<T> var0) {
        boolean var12 = var0.get("_filtered_correct").asBoolean(false);
        if (var12) {
            return var0.remove("_filtered_correct");
        }
        Optional var22 = var0.get("filtered_messages").asStreamOpt().result();
        if (var22.isEmpty()) {
            return var0;
        }
        Dynamic var32 = ComponentDataFixUtils.createEmptyComponent(var0.getOps());
        List<Dynamic> var4 = var0.get("messages").asStreamOpt().result().orElse(Stream.of(new Dynamic[0])).toList();
        List var5 = Streams.mapWithIndex((Stream)((Stream)var22.get()), (var2, var3) -> {
            Dynamic var5 = var3 < (long)var4.size() ? (Dynamic)var4.get((int)var3) : var32;
            return var2.equals((Object)var32) ? var5 : var2;
        }).toList();
        if (var5.stream().allMatch(var1 -> var1.equals((Object)var32))) {
            return var0.remove("filtered_messages");
        }
        return var0.set("filtered_messages", var0.createList(var5.stream()));
    }

    @Override
    protected Typed<?> fix(Typed<?> var0) {
        return var0.update(DSL.remainderFinder(), DropInvalidSignDataFix::fix);
    }
}

