/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import java.util.Locale;

public class DataConverterAddChoices
extends DataFix {
    private final String name;
    private final DSL.TypeReference type;

    public DataConverterAddChoices(Schema var0, String var1, DSL.TypeReference var2) {
        super(var0, true);
        this.name = var1;
        this.type = var2;
    }

    public TypeRewriteRule makeRule() {
        TaggedChoice.TaggedChoiceType var0 = this.getInputSchema().findChoiceType(this.type);
        TaggedChoice.TaggedChoiceType var1 = this.getOutputSchema().findChoiceType(this.type);
        return this.cap(this.name, var0, var1);
    }

    protected final <K> TypeRewriteRule cap(String var0, TaggedChoice.TaggedChoiceType<K> var1, TaggedChoice.TaggedChoiceType<?> var2) {
        if (var1.getKeyType() != var2.getKeyType()) {
            throw new IllegalStateException("Could not inject: key type is not the same");
        }
        TaggedChoice.TaggedChoiceType<?> var3 = var2;
        return this.fixTypeEverywhere(var0, (Type)var1, (Type)var3, var12 -> var1 -> {
            if (!var3.hasType(var1.getFirst())) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown type %s in %s ", var1.getFirst(), this.type));
            }
            return var1;
        });
    }
}

