/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.util.ChatDeserializer;

public class ComponentDataFixUtils {
    private static final String EMPTY_CONTENTS = ComponentDataFixUtils.createTextComponentJson("");

    public static <T> Dynamic<T> createPlainTextComponent(DynamicOps<T> var0, String var1) {
        String var2 = ComponentDataFixUtils.createTextComponentJson(var1);
        return new Dynamic(var0, var0.createString(var2));
    }

    public static <T> Dynamic<T> createEmptyComponent(DynamicOps<T> var0) {
        return new Dynamic(var0, var0.createString(EMPTY_CONTENTS));
    }

    private static String createTextComponentJson(String var0) {
        JsonObject var1 = new JsonObject();
        var1.addProperty("text", var0);
        return ChatDeserializer.toStableString((JsonElement)var1);
    }

    public static <T> Dynamic<T> createTranslatableComponent(DynamicOps<T> var0, String var1) {
        JsonObject var2 = new JsonObject();
        var2.addProperty("translate", var1);
        return new Dynamic(var0, var0.createString(ChatDeserializer.toStableString((JsonElement)var2)));
    }

    public static <T> Dynamic<T> wrapLiteralStringAsComponent(Dynamic<T> var0) {
        return (Dynamic)DataFixUtils.orElse((Optional)var0.asString().map(var1 -> ComponentDataFixUtils.createPlainTextComponent(var0.getOps(), var1)).result(), var0);
    }
}

