/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class JavaOps
implements DynamicOps<Object> {
    public static final JavaOps INSTANCE = new JavaOps();

    private JavaOps() {
    }

    public Object empty() {
        return null;
    }

    public Object emptyMap() {
        return Map.of();
    }

    public Object emptyList() {
        return List.of();
    }

    public <U> U convertTo(DynamicOps<U> var0, Object var1) {
        if (var1 == null) {
            return (U)var0.empty();
        }
        if (var1 instanceof Map) {
            return (U)this.convertMap(var0, var1);
        }
        if (var1 instanceof ByteList) {
            ByteList var2 = (ByteList)var1;
            return (U)var0.createByteList(ByteBuffer.wrap(var2.toByteArray()));
        }
        if (var1 instanceof IntList) {
            IntList var2 = (IntList)var1;
            return (U)var0.createIntList(var2.intStream());
        }
        if (var1 instanceof LongList) {
            LongList var2 = (LongList)var1;
            return (U)var0.createLongList(var2.longStream());
        }
        if (var1 instanceof List) {
            return (U)this.convertList(var0, var1);
        }
        if (var1 instanceof String) {
            String var2 = (String)var1;
            return (U)var0.createString(var2);
        }
        if (var1 instanceof Boolean) {
            Boolean var2 = (Boolean)var1;
            return (U)var0.createBoolean(var2.booleanValue());
        }
        if (var1 instanceof Byte) {
            Byte var2 = (Byte)var1;
            return (U)var0.createByte(var2.byteValue());
        }
        if (var1 instanceof Short) {
            Short var2 = (Short)var1;
            return (U)var0.createShort(var2.shortValue());
        }
        if (var1 instanceof Integer) {
            Integer var2 = (Integer)var1;
            return (U)var0.createInt(var2.intValue());
        }
        if (var1 instanceof Long) {
            Long var2 = (Long)var1;
            return (U)var0.createLong(var2.longValue());
        }
        if (var1 instanceof Float) {
            Float var2 = (Float)var1;
            return (U)var0.createFloat(var2.floatValue());
        }
        if (var1 instanceof Double) {
            Double var2 = (Double)var1;
            return (U)var0.createDouble(var2.doubleValue());
        }
        if (var1 instanceof Number) {
            Number var2 = (Number)var1;
            return (U)var0.createNumeric(var2);
        }
        throw new IllegalStateException("Don't know how to convert " + var1);
    }

    public DataResult<Number> getNumberValue(Object var0) {
        if (var0 instanceof Number) {
            Number var1 = (Number)var0;
            return DataResult.success((Object)var1);
        }
        return DataResult.error(() -> "Not a number: " + var0);
    }

    public Object createNumeric(Number var0) {
        return var0;
    }

    public Object createByte(byte var0) {
        return var0;
    }

    public Object createShort(short var0) {
        return var0;
    }

    public Object createInt(int var0) {
        return var0;
    }

    public Object createLong(long var0) {
        return var0;
    }

    public Object createFloat(float var0) {
        return Float.valueOf(var0);
    }

    public Object createDouble(double var0) {
        return var0;
    }

    public DataResult<Boolean> getBooleanValue(Object var0) {
        if (var0 instanceof Boolean) {
            Boolean var1 = (Boolean)var0;
            return DataResult.success((Object)var1);
        }
        return DataResult.error(() -> "Not a boolean: " + var0);
    }

    public Object createBoolean(boolean var0) {
        return var0;
    }

    public DataResult<String> getStringValue(Object var0) {
        if (var0 instanceof String) {
            String var1 = (String)var0;
            return DataResult.success((Object)var1);
        }
        return DataResult.error(() -> "Not a string: " + var0);
    }

    public Object createString(String var0) {
        return var0;
    }

    public DataResult<Object> mergeToList(Object var0, Object var1) {
        if (var0 == this.empty()) {
            return DataResult.success(List.of(var1));
        }
        if (var0 instanceof List) {
            List var2 = (List)var0;
            if (var2.isEmpty()) {
                return DataResult.success(List.of(var1));
            }
            return DataResult.success((Object)ImmutableList.builder().addAll((Iterable)var2).add(var1).build());
        }
        return DataResult.error(() -> "Not a list: " + var0);
    }

    public DataResult<Object> mergeToList(Object var0, List<Object> var1) {
        if (var0 == this.empty()) {
            return DataResult.success(var1);
        }
        if (var0 instanceof List) {
            List var2 = (List)var0;
            if (var2.isEmpty()) {
                return DataResult.success(var1);
            }
            return DataResult.success((Object)ImmutableList.builder().addAll((Iterable)var2).addAll(var1).build());
        }
        return DataResult.error(() -> "Not a list: " + var0);
    }

    public DataResult<Object> mergeToMap(Object var0, Object var1, Object var2) {
        if (var0 == this.empty()) {
            return DataResult.success(Map.of(var1, var2));
        }
        if (var0 instanceof Map) {
            Map var3 = (Map)var0;
            if (var3.isEmpty()) {
                return DataResult.success(Map.of(var1, var2));
            }
            ImmutableMap.Builder var4 = ImmutableMap.builderWithExpectedSize((int)(var3.size() + 1));
            var4.putAll(var3);
            var4.put(var1, var2);
            return DataResult.success((Object)var4.buildKeepingLast());
        }
        return DataResult.error(() -> "Not a map: " + var0);
    }

    public DataResult<Object> mergeToMap(Object var0, Map<Object, Object> var1) {
        if (var0 == this.empty()) {
            return DataResult.success(var1);
        }
        if (var0 instanceof Map) {
            Map var2 = (Map)var0;
            if (var2.isEmpty()) {
                return DataResult.success(var1);
            }
            ImmutableMap.Builder var3 = ImmutableMap.builderWithExpectedSize((int)(var2.size() + var1.size()));
            var3.putAll(var2);
            var3.putAll(var1);
            return DataResult.success((Object)var3.buildKeepingLast());
        }
        return DataResult.error(() -> "Not a map: " + var0);
    }

    private static Map<Object, Object> mapLikeToMap(MapLike<Object> var0) {
        return (Map)var0.entries().collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
    }

    public DataResult<Object> mergeToMap(Object var0, MapLike<Object> var12) {
        if (var0 == this.empty()) {
            return DataResult.success(JavaOps.mapLikeToMap(var12));
        }
        if (var0 instanceof Map) {
            Map var2 = (Map)var0;
            if (var2.isEmpty()) {
                return DataResult.success(JavaOps.mapLikeToMap(var12));
            }
            ImmutableMap.Builder var3 = ImmutableMap.builderWithExpectedSize((int)var2.size());
            var3.putAll(var2);
            var12.entries().forEach(var1 -> var3.put(var1.getFirst(), var1.getSecond()));
            return DataResult.success((Object)var3.buildKeepingLast());
        }
        return DataResult.error(() -> "Not a map: " + var0);
    }

    static Stream<Pair<Object, Object>> getMapEntries(Map<?, ?> var02) {
        return var02.entrySet().stream().map(var0 -> Pair.of(var0.getKey(), var0.getValue()));
    }

    public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object var0) {
        if (var0 instanceof Map) {
            Map var1 = (Map)var0;
            return DataResult.success(JavaOps.getMapEntries(var1));
        }
        return DataResult.error(() -> "Not a map: " + var0);
    }

    public DataResult<Consumer<BiConsumer<Object, Object>>> getMapEntries(Object var0) {
        if (var0 instanceof Map) {
            Map var1 = (Map)var0;
            return DataResult.success(var1::forEach);
        }
        return DataResult.error(() -> "Not a map: " + var0);
    }

    public Object createMap(Stream<Pair<Object, Object>> var0) {
        return var0.collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
    }

    public DataResult<MapLike<Object>> getMap(Object var0) {
        if (var0 instanceof Map) {
            final Map var1 = (Map)var0;
            return DataResult.success((Object)new MapLike<Object>(){

                @Nullable
                public Object get(Object var0) {
                    return var1.get(var0);
                }

                @Nullable
                public Object get(String var0) {
                    return var1.get(var0);
                }

                public Stream<Pair<Object, Object>> entries() {
                    return JavaOps.getMapEntries(var1);
                }

                public String toString() {
                    return "MapLike[" + var1 + "]";
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + var0);
    }

    public Object createMap(Map<Object, Object> var0) {
        return var0;
    }

    public DataResult<Stream<Object>> getStream(Object var02) {
        if (var02 instanceof List) {
            List var1 = (List)var02;
            return DataResult.success(var1.stream().map(var0 -> var0));
        }
        return DataResult.error(() -> "Not an list: " + var02);
    }

    public DataResult<Consumer<Consumer<Object>>> getList(Object var0) {
        if (var0 instanceof List) {
            List var1 = (List)var0;
            return DataResult.success(var1::forEach);
        }
        return DataResult.error(() -> "Not an list: " + var0);
    }

    public Object createList(Stream<Object> var0) {
        return var0.toList();
    }

    public DataResult<ByteBuffer> getByteBuffer(Object var0) {
        if (var0 instanceof ByteList) {
            ByteList var1 = (ByteList)var0;
            return DataResult.success((Object)ByteBuffer.wrap(var1.toByteArray()));
        }
        return DataResult.error(() -> "Not a byte list: " + var0);
    }

    public Object createByteList(ByteBuffer var0) {
        ByteBuffer var1 = var0.duplicate().clear();
        ByteArrayList var2 = new ByteArrayList();
        var2.size(var1.capacity());
        var1.get(0, var2.elements(), 0, var2.size());
        return var2;
    }

    public DataResult<IntStream> getIntStream(Object var0) {
        if (var0 instanceof IntList) {
            IntList var1 = (IntList)var0;
            return DataResult.success((Object)var1.intStream());
        }
        return DataResult.error(() -> "Not an int list: " + var0);
    }

    public Object createIntList(IntStream var0) {
        return IntArrayList.toList((IntStream)var0);
    }

    public DataResult<LongStream> getLongStream(Object var0) {
        if (var0 instanceof LongList) {
            LongList var1 = (LongList)var0;
            return DataResult.success((Object)var1.longStream());
        }
        return DataResult.error(() -> "Not a long list: " + var0);
    }

    public Object createLongList(LongStream var0) {
        return LongArrayList.toList((LongStream)var0);
    }

    public Object remove(Object var0, String var1) {
        if (var0 instanceof Map) {
            Map var2 = (Map)var0;
            LinkedHashMap var3 = new LinkedHashMap(var2);
            var3.remove(var1);
            return DataResult.success(Map.copyOf(var3));
        }
        return DataResult.error(() -> "Not a map: " + var0);
    }

    public RecordBuilder<Object> mapBuilder() {
        return new a<Object>(this);
    }

    public String toString() {
        return "Java";
    }

    static final class a<T>
    extends RecordBuilder.AbstractUniversalBuilder<T, ImmutableMap.Builder<T, T>> {
        public a(DynamicOps<T> var0) {
            super(var0);
        }

        protected ImmutableMap.Builder<T, T> initBuilder() {
            return ImmutableMap.builder();
        }

        protected ImmutableMap.Builder<T, T> append(T var0, T var1, ImmutableMap.Builder<T, T> var2) {
            return var2.put(var0, var1);
        }

        protected DataResult<T> build(ImmutableMap.Builder<T, T> var0, T var1) {
            ImmutableMap var2;
            try {
                var2 = var0.buildOrThrow();
            }
            catch (IllegalArgumentException var3) {
                return DataResult.error(() -> "Can't build map: " + var3.getMessage());
            }
            return this.ops().mergeToMap(var1, (Map)var2);
        }

        protected /* synthetic */ Object append(Object object, Object object2, Object object3) {
            return this.append(object, object2, (ImmutableMap.Builder)object3);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.build((ImmutableMap.Builder)object, object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }
}

