/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public abstract class ResourceDataJson
extends ResourceDataAbstract<Map<MinecraftKey, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Gson gson;
    private final String directory;

    public ResourceDataJson(Gson var0, String var1) {
        this.gson = var0;
        this.directory = var1;
    }

    @Override
    protected Map<MinecraftKey, JsonElement> prepare(IResourceManager var0, GameProfilerFiller var1) {
        HashMap<MinecraftKey, JsonElement> var2 = new HashMap<MinecraftKey, JsonElement>();
        ResourceDataJson.scanDirectory(var0, this.directory, this.gson, var2);
        return var2;
    }

    public static void scanDirectory(IResourceManager var0, String var1, Gson var2, Map<MinecraftKey, JsonElement> var3) {
        FileToIdConverter var4 = FileToIdConverter.json(var1);
        for (Map.Entry<MinecraftKey, IResource> var6 : var4.listMatchingResources(var0).entrySet()) {
            MinecraftKey var7 = var6.getKey();
            MinecraftKey var8 = var4.fileToId(var7);
            try {
                BufferedReader var9 = var6.getValue().openAsReader();
                try {
                    JsonElement var10 = ChatDeserializer.fromJson(var2, (Reader)var9, JsonElement.class);
                    JsonElement var11 = var3.put(var8, var10);
                    if (var11 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + var8);
                }
                finally {
                    if (var9 == null) continue;
                    ((Reader)var9).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var9) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{var8, var7, var9});
            }
        }
    }

    @Override
    protected /* synthetic */ Object prepare(IResourceManager iResourceManager, GameProfilerFiller gameProfilerFiller) {
        return this.prepare(iResourceManager, gameProfilerFiller);
    }
}

